/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildtrigger;

import com.atlassian.bamboo.build.BuildTriggerCondition;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BaseBuildConfigurationAwarePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlansGreenCondition
extends BaseBuildConfigurationAwarePlugin
implements BuildTriggerCondition {
    private static final Logger log = Logger.getLogger(PlansGreenCondition.class);
    private static final String PREFIX = "custom.triggerrCondition.plansGreen";
    private static final String FIELD_ENABLED = "custom.triggerrCondition.plansGreen.enabled";
    private static final String FIELD_PLANS = "custom.triggerrCondition.plansGreen.plans";
    private PlanManager planManager;

    @NotNull
    public Map<String, String> getConfigurationMap(@NotNull HierarchicalConfiguration configuration) {
        HashMap result = Maps.newHashMap();
        boolean enabled = configuration.getBoolean(FIELD_ENABLED, false);
        result.put(FIELD_ENABLED, Boolean.toString(enabled));
        if (enabled) {
            result.put(FIELD_PLANS, configuration.getString(FIELD_PLANS));
        }
        return result;
    }

    @Deprecated
    @NotNull
    public BuildTriggerCondition.ExecutionPreference getExecutionPreference(ImmutablePlan plan) {
        return this.getExecutionPreference(plan, plan.getBuildDefinition().getCustomConfiguration());
    }

    @NotNull
    public BuildTriggerCondition.ExecutionPreference getExecutionPreference(ImmutablePlan plan, Map<String, String> configuration) {
        boolean enabled = Boolean.parseBoolean(configuration.get(FIELD_ENABLED));
        if (enabled) {
            List<String> planKeys = this.getPlanKeys(configuration.get(FIELD_PLANS));
            for (String key : planKeys) {
                ResultsSummary summary;
                Plan dependantPlan = this.planManager.getPlanByKeyIfOfType(PlanKeys.getPlanKey((String)key), TopLevelPlan.class);
                if (dependantPlan == null || (summary = dependantPlan.getLatestResultsSummary()) == null || summary.getBuildState() == BuildState.SUCCESS) continue;
                return BuildTriggerCondition.ExecutionPreference.SHOULD_STOP;
            }
        }
        return BuildTriggerCondition.ExecutionPreference.NONE;
    }

    protected void populateContextForView(@NotNull Map<String, Object> context, @NotNull Plan plan) {
        Map configuration = plan.getBuildDefinition().getCustomConfiguration();
        Boolean enabled = Boolean.valueOf((String)configuration.get(FIELD_ENABLED));
        context.put("triggerConditionEnabled", enabled);
        if (enabled.booleanValue()) {
            context.put("planKeys", this.getPlanKeys((String)configuration.get(FIELD_PLANS)));
        }
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        boolean enabled = buildConfiguration.getBoolean(FIELD_ENABLED);
        if (enabled) {
            List<String> planKeys = this.getPlanKeys(buildConfiguration.getString(FIELD_PLANS, ""));
            if (planKeys.size() < 1) {
                errorCollection.addError(FIELD_PLANS, "Please enter at least one plan key");
            }
            for (String planKey : planKeys) {
                Plan plan = this.planManager.getPlanByKey(planKey, Plan.class);
                if (plan == null) {
                    errorCollection.addError(FIELD_PLANS, "No plan with key " + planKey + " exists in Bamboo");
                    continue;
                }
                if (plan instanceof TopLevelPlan) continue;
                errorCollection.addError(FIELD_PLANS, planKey + " is a job and can not be used in this field.");
            }
        }
        return errorCollection;
    }

    @NotNull
    private List<String> getPlanKeys(String keysString) {
        ArrayList planKeys = Lists.newArrayList();
        for (String planKey : keysString.split(",")) {
            if (!StringUtils.isNotBlank((String)planKey)) continue;
            planKeys.add(planKey.trim().toUpperCase());
        }
        return planKeys;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }
}

