package com.atlassian.bamboo.plugins.tomcat.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

public class DeployAppConfigurator extends AbstractTomcatConfigurator
{
    private static final Logger log = Logger.getLogger(DeployAppConfigurator.class);
    // ------------------------------------------------------------------------------------------------------- Constants

    public static final String APP_VERSION = "appVersion";
    public static final String WAR_FILE_PATH = "warFilePath";
    public static final String DEPLOYMENT_TAG = "deploymentTag";

    private static final Set<String> FIELDS_TO_COPY = ImmutableSet.<String>builder().add(APP_VERSION, WAR_FILE_PATH, DEPLOYMENT_TAG).build();

    // ------------------------------------------------------------------------------------------------- Type Properties
    // ---------------------------------------------------------------------------------------------------- Dependencies
    // ---------------------------------------------------------------------------------------------------- Constructors
    // ----------------------------------------------------------------------------------------------- Interface Methods

    @Override
    protected Set<String> getFieldsToCopy()
    {
        return FIELDS_TO_COPY;
    }

    @Override
    public void validate(@NotNull final ActionParametersMap params, @NotNull final ErrorCollection errorCollection)
    {
        super.validate(params, errorCollection);

        if (StringUtils.isEmpty(params.getString(WAR_FILE_PATH)))
        {
            errorCollection.addError(WAR_FILE_PATH, textProvider.getText("tomcat.war.error"));
        }
    }

    // -------------------------------------------------------------------------------------------------- Action Methods
    // -------------------------------------------------------------------------------------------------- Public Methods
    // -------------------------------------------------------------------------------------- Basic Accessors / Mutators
}
