package com.atlassian.bamboo.plugins.tomcat.tasks;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.tomcat.configuration.DeployAppConfigurator;
import com.atlassian.bamboo.plugins.tomcat.manager.TaskTomcatConnection;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatApplicationManager;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatApplicationManagerImpl;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatConnection;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatResult;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.variable.CustomVariableContext;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;

public class ReloadAppTask implements CommonTaskType
{
    private static final Logger log = Logger.getLogger(ReloadAppTask.class);
    // ------------------------------------------------------------------------------------------------------- Constants
    // ------------------------------------------------------------------------------------------------- Type Properties
    // ---------------------------------------------------------------------------------------------------- Dependencies
    private final  EncryptionService encryptionService;
    private final CustomVariableContext customVariableContext;

    // ---------------------------------------------------------------------------------------------------- Constructors
    public ReloadAppTask(final EncryptionService encryptionService, final CustomVariableContext customVariableContext)
    {
        this.encryptionService = encryptionService;
        this.customVariableContext = customVariableContext;
    }
    // ----------------------------------------------------------------------------------------------- Interface Methods

    @NotNull
    @Override
    public TaskResult execute(@NotNull final CommonTaskContext taskContext) throws TaskException
    {
        final BuildLogger buildLogger = taskContext.getBuildLogger();
        final TomcatConnection connection = new TaskTomcatConnection(taskContext, encryptionService);
        final TomcatApplicationManager tomcatManager = new TomcatApplicationManagerImpl(connection, taskContext, customVariableContext, buildLogger);
        final TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder(taskContext);

        final String context = taskContext.getConfigurationMap().get(DeployAppConfigurator.APP_CONTEXT);

        try
        {
            buildLogger.addBuildLogEntry("Reloading application at context '"
                                                 + context
                                                 + "' on server '"
                                                 + connection.getURL()
                                                 + "'");

            TomcatResult result = tomcatManager.reloadApplication(context);
            if (result.isSuccessful())
            {
                taskResultBuilder.success();
                buildLogger.addBuildLogEntry("The application has been reloaded successfully");
            }
            else
            {
                final String message = "The application could not be reloaded successfully: " + result.getReason();
                buildLogger.addErrorLogEntry(message);
                taskResultBuilder.failed();
            }
        }
        catch (IOException e)
        {
            final String log = "Could not reload application: " + e.getMessage();
            buildLogger.addErrorLogEntry(log);
            taskResultBuilder.failedWithError();
        }

        return taskResultBuilder.build();
    }

    // -------------------------------------------------------------------------------------------------- Action Methods
    // -------------------------------------------------------------------------------------------------- Public Methods
    // -------------------------------------------------------------------------------------- Basic Accessors / Mutators
}
