/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.testresultparser.testng;

import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TestMethodExceptionEntity {
    private static final Logger log = Logger.getLogger(TestMethodExceptionEntity.class);
    private final String className;
    private final String message;
    private final String stacktrace;

    public TestMethodExceptionEntity(String className, String message, String stacktrace) {
        this.className = className;
        this.message = message;
        this.stacktrace = stacktrace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public TestCaseResultError toTestCaseResultError() {
        StringBuilder contentBuilder = new StringBuilder().append(String.format("Classname: %s\n", this.className)).append(String.format("Message: %s\n", this.message)).append("Stacktrace:\n").append(this.stacktrace);
        return new TestCaseResultErrorImpl(contentBuilder.toString());
    }

    static class Builder {
        private String className;
        private String message;
        private String stacktrace;

        Builder() {
        }

        public Builder className(@NotNull String className) {
            this.className = className;
            return this;
        }

        public Builder message(@NotNull String message) {
            this.message = message;
            return this;
        }

        public Builder stacktrace(@NotNull String stacktrace) {
            this.stacktrace = stacktrace;
            return this;
        }

        public TestMethodExceptionEntity build() {
            return new TestMethodExceptionEntity(this.className, this.message, this.stacktrace);
        }
    }
}

