/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.testresultparser.testng;

import com.atlassian.bamboo.plugins.testresultparser.testng.TestMethodExceptionEntity;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestMethodEntity {
    private static final Logger log = Logger.getLogger(TestMethodEntity.class);
    private final String methodName;
    private final boolean isConfig;
    private final String status;
    private final long durationMs;
    private final List<String> params = new ArrayList<String>();
    private final List<String> reporterOutput = new ArrayList<String>();
    private TestMethodExceptionEntity exception;

    public TestMethodEntity(@NotNull String methodName, boolean isConfig, @NotNull String status, long durationMs) {
        this.methodName = methodName;
        this.isConfig = isConfig;
        this.status = status;
        this.durationMs = durationMs;
    }

    public void addParam(@Nullable String value) {
        this.params.add(value);
    }

    public void addReporterOutput(@Nullable String value) {
        this.reporterOutput.add(value);
    }

    public void setException(TestMethodExceptionEntity exception) {
        this.exception = exception;
    }

    public String getFullName() {
        StringBuilder builder = new StringBuilder(this.methodName);
        if (!this.params.isEmpty()) {
            builder.append("(");
            Joiner.on((String)", ").useForNull("null").appendTo(builder, this.params);
            builder.append(")");
        }
        return builder.toString();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isConfig() {
        return this.isConfig;
    }

    public String getStatus() {
        return this.status;
    }

    public long getDurationMs() {
        return this.durationMs;
    }

    public ImmutableList<String> getReporterOutput() {
        return ImmutableList.copyOf(this.reporterOutput);
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public TestMethodExceptionEntity getException() {
        return this.exception;
    }
}

