/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.testresultparser.task.exporter;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.TestParserTask;
import com.atlassian.bamboo.specs.model.task.TestParserTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class TestParserTaskExporter
implements TaskDefinitionExporter {
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        TestParserTaskProperties testParserTaskProperties = (TestParserTaskProperties)Narrow.downTo((Object)taskProperties, TestParserTaskProperties.class);
        if (testParserTaskProperties != null) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            cfg.put("testResultsDirectory", Joiner.on((String)", ").join((Iterable)testParserTaskProperties.getResultDirectories()));
            cfg.put("pickupOutdatedFiles", Boolean.toString(testParserTaskProperties.getPickUpTestResultsCreatedOutsideOfThisBuild()));
            return cfg;
        }
        throw new IllegalStateException("Don't know how to import task properties of type: " + taskProperties.getClass().getName());
    }

    @NotNull
    protected abstract TestParserTaskProperties.TestType getTestType();

    @NotNull
    public Task<TestParserTask, TestParserTaskProperties> toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map taskConfiguration = taskDefinition.getConfiguration();
        TestParserTask taskBuilder = new TestParserTask(this.getTestType());
        if (taskConfiguration.containsKey("pickupOutdatedFiles")) {
            Boolean pickUpTestResultsCreatedOutsideOfThisBuild = Boolean.parseBoolean((String)taskConfiguration.get("pickupOutdatedFiles"));
            taskBuilder.pickUpTestResultsCreatedOutsideOfThisBuild(pickUpTestResultsCreatedOutsideOfThisBuild);
        }
        Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)taskConfiguration.get("testResultsDirectory")).forEach(xva$0 -> taskBuilder.resultDirectories(new String[]{xva$0}));
        return taskBuilder;
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        return Collections.emptyList();
    }
}

