/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webrepository.stash;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.deployments.versions.history.commit.DeploymentVersionVcsCommit;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.webrepository.AbstractWebRepositoryViewer;
import com.atlassian.bamboo.webrepository.DeploymentsAwareCommitUrlProvider;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.UrlUtils;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class LegacyStashWebRepositoryViewer
extends AbstractWebRepositoryViewer
implements DeploymentsAwareCommitUrlProvider {
    private static final Logger log = Logger.getLogger(LegacyStashWebRepositoryViewer.class);
    private static final String FULL_COMMIT_VIEW_TEMPLATE = "stashViewOfCommits.ftl";
    private static final String SUMMARY_COMMIT_VIEW_TEMPLATE = "/templates/plugins/webRepository/commonCommitSummaryView.ftl";
    protected static final String STASH_URL = "webRepository.stash.url";
    protected static final String STASH_PROJECT = "webRepository.stash.project";
    protected static final String STASH_REPOSITORY_NAME = "webRepository.stash.repositoryName";
    private String stashUrl;
    private String stashProject;
    private String stashRepositoryName;
    private transient CustomVariableContext customVariableContext;
    private TextProvider textProvider;

    @NotNull
    public Collection<String> getSupportedRepositories() {
        return ImmutableList.of((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2", (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:git", (Object)"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver", (Object)"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:stash");
    }

    public String getHtmlForCommitsFull(@NotNull ResultsSummary resultsSummary, @NotNull RepositoryChangeset repositoryChangeset, @NotNull RepositoryData repositoryData) {
        ImmutableMap context = ImmutableMap.of((Object)"buildResultsSummary", (Object)resultsSummary, (Object)"repositoryChangeset", (Object)repositoryChangeset, (Object)"repositoryData", (Object)repositoryData, (Object)"linkGenerator", (Object)((Object)this));
        return this.templateRenderer.render(FULL_COMMIT_VIEW_TEMPLATE, (Map)context);
    }

    public String getHtmlForCommitsSummary(@NotNull ResultsSummary resultsSummary, @NotNull RepositoryChangeset repositoryChangeset, @NotNull RepositoryData repositoryData, int maxChanges) {
        ImmutableMap context = ImmutableMap.of((Object)"buildResultsSummary", (Object)resultsSummary, (Object)"repositoryChangeset", (Object)repositoryChangeset, (Object)"repositoryData", (Object)repositoryData, (Object)"linkGenerator", (Object)((Object)this), (Object)"maxChanges", (Object)maxChanges);
        return this.templateRenderer.render(SUMMARY_COMMIT_VIEW_TEMPLATE, (Map)context);
    }

    public void populateFromParams(@NotNull ActionParametersMap params) {
        this.setStashUrl(params.getString(STASH_URL));
        this.setStashProject(params.getString(STASH_PROJECT));
        this.setStashRepositoryName(params.getString(STASH_REPOSITORY_NAME));
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.setStashUrl(config.getString(STASH_URL));
        this.setStashProject(config.getString(STASH_PROJECT));
        this.setStashRepositoryName(config.getString(STASH_REPOSITORY_NAME));
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(STASH_URL, (Object)com.atlassian.bamboo.util.UrlUtils.correctlyFormatUrl((String)this.getStashUrl()));
        configuration.setProperty(STASH_PROJECT, (Object)this.getStashProject());
        configuration.setProperty(STASH_REPOSITORY_NAME, (Object)this.getStashRepositoryName());
        return configuration;
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        String stashRepositoryName;
        String stashProject;
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        String stashUrl = buildConfiguration.getString(STASH_URL);
        if (StringUtils.isBlank((CharSequence)stashUrl)) {
            errorCollection.addError(STASH_URL, this.textProvider.getText("webRepositoryViewer.stash.error.missingUrl"));
        }
        if (!StringUtils.isBlank((CharSequence)(stashUrl = this.customVariableContext.substituteString(stashUrl))) && !UrlUtils.verifyHierachicalURI((String)stashUrl)) {
            errorCollection.addError(STASH_URL, this.textProvider.getText("webRepositoryViewer.stash.error.invalidUrl"));
        }
        if (StringUtils.isBlank((CharSequence)(stashProject = buildConfiguration.getString(STASH_PROJECT)))) {
            errorCollection.addError(STASH_PROJECT, this.textProvider.getText("webRepositoryViewer.stash.error.missingProject"));
        }
        if (StringUtils.isBlank((CharSequence)(stashRepositoryName = buildConfiguration.getString(STASH_REPOSITORY_NAME)))) {
            errorCollection.addError(STASH_REPOSITORY_NAME, this.textProvider.getText("webRepositoryViewer.stash.error.missingRepo"));
        }
        return errorCollection;
    }

    @Nullable
    public String getWebRepositoryUrlForCommit(Commit commit, @NotNull RepositoryData repositoryData) {
        return this.generateLinkToStashInstance("commits/" + commit.getChangeSetId());
    }

    @Nullable
    public String getWebRepositoryUrlForRevision(String revisionId, @NotNull RepositoryData repositoryData) {
        return this.generateLinkToStashInstance("commits/" + revisionId);
    }

    public Map<Commit, String> getWebRepositoryUrlForCommits(Collection<Commit> commits, RepositoryData repositoryDefinition) {
        HashMap<Commit, String> commitsToUrls = new HashMap<Commit, String>();
        String changeLogPrefix = this.getStashUrlPrefix();
        if (changeLogPrefix != null) {
            for (Commit commit : commits) {
                commitsToUrls.put(commit, changeLogPrefix + "commits/" + commit.getChangeSetId());
            }
        }
        return commitsToUrls;
    }

    public Map<DeploymentVersionVcsCommit, String> getWebRepositoryUrlForDeploymentVersionCommits(Collection<DeploymentVersionVcsCommit> commits, RepositoryData repositoryData) {
        HashMap<DeploymentVersionVcsCommit, String> commitsToUrls = new HashMap<DeploymentVersionVcsCommit, String>();
        String changeLogPrefix = this.getStashUrlPrefix();
        if (changeLogPrefix != null) {
            for (DeploymentVersionVcsCommit commit : commits) {
                commitsToUrls.put(commit, changeLogPrefix + "commits/" + commit.getChangeSetId());
            }
        }
        return commitsToUrls;
    }

    @Nullable
    public String getStashUrlForFile(@NotNull CommitFile file, RepositoryData repositoryData) {
        return this.generateLinkToStashInstance("browse/" + file.getName());
    }

    @Nullable
    public String getStashUrlForFileAtItsRevision(@NotNull CommitFile file, RepositoryData repositoryData) {
        return this.generateLinkToStashInstance("browse/" + file.getName() + "?at=" + file.getRevision());
    }

    @Nullable
    public String getStashUrlForFileDiff(@NotNull CommitFile file, RepositoryData repositoryData) {
        return this.generateLinkToStashInstance("diff/" + file.getName() + "?at=" + file.getRevision() + "&until=" + file.getRevision());
    }

    public String getWebRepositoryUrlForFile(@NotNull CommitFile file, RepositoryData repositoryData) {
        return this.getStashUrlForFile(file, repositoryData);
    }

    public String getWebRepositoryUrlForRevision(@NotNull CommitFile file, RepositoryData repositoryData) {
        return this.getStashUrlForFileAtItsRevision(file, repositoryData);
    }

    public String getWebRepositoryUrlForDiff(@NotNull CommitFile file, RepositoryData repositoryData) {
        return this.getStashUrlForFileDiff(file, repositoryData);
    }

    private String generateLinkToStashInstance(@NotNull String suffix) {
        String prefix = this.getStashUrlPrefix();
        if (prefix == null) {
            log.warn((Object)"Stash url is not defined. Can not generate links for repository web viewer.");
            return null;
        }
        return prefix + suffix;
    }

    private String getStashUrlPrefix() {
        String substitutedRepositoryName;
        String substitutedProject;
        if (this.stashUrl == null) {
            return null;
        }
        String substitutedStashUrl = this.customVariableContext.substituteString(this.stashUrl);
        if (substitutedStashUrl == null) {
            log.warn((Object)("Variable substitution failed for stash url '" + this.stashUrl + "', using original url."));
            substitutedStashUrl = this.stashUrl;
        }
        if ((substitutedProject = this.customVariableContext.substituteString(this.stashProject)) == null) {
            log.warn((Object)("Variable substitution failed for stash project key '" + this.stashProject + "', using original name."));
            substitutedProject = this.stashProject;
        }
        if ((substitutedRepositoryName = this.customVariableContext.substituteString(this.stashRepositoryName)) == null) {
            log.warn((Object)("Variable substitution failed for stash repository name '" + this.stashRepositoryName + "', using original name."));
            substitutedRepositoryName = this.stashRepositoryName;
        }
        StringBuilder result = new StringBuilder();
        result.append(substitutedStashUrl);
        if (!substitutedStashUrl.endsWith("/")) {
            result.append("/");
        }
        result.append("projects/").append(substitutedProject).append("/repos/").append(substitutedRepositoryName).append("/");
        return result.toString();
    }

    public String getStashUrl() {
        return this.stashUrl;
    }

    public void setStashUrl(@Nullable String stashUrl) {
        this.stashUrl = StringUtils.trim((String)stashUrl);
    }

    public String getStashProject() {
        return this.stashProject;
    }

    public void setStashProject(@Nullable String stashProject) {
        this.stashProject = StringUtils.trim((String)stashProject);
    }

    public String getStashRepositoryName() {
        return this.stashRepositoryName;
    }

    public void setStashRepositoryName(@Nullable String stashRepositoryName) {
        this.stashRepositoryName = StringUtils.trim((String)stashRepositoryName);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

