[#import "/lib/ace.ftl" as ace ]

[@s.select
        key='task.script.interpreter'
        listKey='name'
        listValue='label'
        optionDescription='value'
        list=interpreterTypes
        name='interpreter' /]

[@s.select
        key='task.script.location'
        listKey='key'
        listValue='value'
        list=locationTypes
        name='scriptLocation'
        toggle=true /]

[@ui.bambooSection dependsOn='scriptLocation' showOn='FILE']
    [@s.textfield key='task.script.script' name='script' required=true cssClass="long-field" /]
[/@ui.bambooSection]

[@ui.bambooSection dependsOn='scriptLocation' showOn='INLINE']
    [@ace.textarea labelKey='task.script.body' name="scriptBody" required=true /]
[/@ui.bambooSection]

<script type="text/javascript">
    (function ($)  {
        window.syntaxHighlightingUpdate = function() {
            var editor = scriptBody_ref,
                    DefaultHighlightMode = ace.require("ace/mode/sh").Mode,
                    PowershellHighlightMode = ace.require("ace/mode/powershell").Mode;
            if ($("#interpreter").val() == ('POWERSHELL')) {
                editor.getSession().setMode(new PowershellHighlightMode());
            } else {
                editor.getSession().setMode(new DefaultHighlightMode());
            }
        }
        $("#interpreter").on('change', syntaxHighlightingUpdate);
        syntaxHighlightingUpdate();
    }(jQuery));
</script>

[@s.textfield key='task.script.argument' name='argument' cssClass="long-field" /]

[@s.textfield key='builder.common.env' name='environmentVariables' cssClass="long-field" /]
[@s.textfield key='builder.common.sub' name='workingSubDirectory' cssClass="long-field" /]
