/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.php.task;

import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.plugins.TaskProcessCommandDecorator;
import com.atlassian.bamboo.util.BambooFileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PhpUnitBuildTaskCloverCommandDecorator
implements TaskProcessCommandDecorator {
    private static final Logger log = Logger.getLogger(PhpUnitBuildTaskCloverCommandDecorator.class);
    static final String CFG_CLOVER_EXISTS = "custom.clover.exists";
    static final String CFG_CLOVER_PATH = "custom.clover.path";
    static final String CLOVER_FILENAME = "clover.xml";

    @NotNull
    public List<String> decorate(@NotNull TaskContext taskContext, @NotNull List<String> command) {
        if (Boolean.parseBoolean(this.getCustomConfiguration(taskContext).get(CFG_CLOVER_EXISTS))) {
            String cloverCoverageFilename = BambooFileUtils.relativizePath((File)taskContext.getRootDirectory(), (File)taskContext.getWorkingDirectory(), (String)this.getCloverCoverageFilename(taskContext));
            command.addAll(1, Arrays.asList("--coverage-clover", cloverCoverageFilename));
        }
        return command;
    }

    @NotNull
    private String getCloverCoverageFilename(@NotNull TaskContext taskContext) {
        String cloverXmlPath = this.getCustomConfiguration(taskContext).get(CFG_CLOVER_PATH);
        if (StringUtils.isNotEmpty((String)cloverXmlPath)) {
            if (!(cloverXmlPath = StringUtils.substringBeforeLast((String)StringUtils.substringBefore((String)StringUtils.substringBefore((String)cloverXmlPath, (String)"?"), (String)"*"), (String)File.separator)).endsWith(".xml")) {
                cloverXmlPath = cloverXmlPath + File.separator + CLOVER_FILENAME;
            }
            return cloverXmlPath;
        }
        return CLOVER_FILENAME;
    }

    @NotNull
    private Map<String, String> getCustomConfiguration(@NotNull TaskContext taskContext) {
        Map customConfiguration = taskContext.getBuildContext().getBuildDefinition().getCustomConfiguration();
        if (customConfiguration != null) {
            return customConfiguration;
        }
        return Collections.emptyMap();
    }
}

