/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.vstest;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugin.dotnet.support.AbstractDotNetTaskConfigurator;
import com.atlassian.bamboo.plugin.dotnet.tests.vstest.VSTestDiscoverCapabilityTypeModule;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VSTestRunnerConfigurator
extends AbstractDotNetTaskConfigurator
implements BuildTaskRequirementSupport,
TaskTestResultsSupport {
    private static final Set<String> FIELDS_TO_COPY = Sets.newHashSet((Object[])new String[]{"label", "vstestSettings", "vstestEnableCodeCoverage", "vstestInIsolation", "vstestPlatform", "vstestFramework", "vstestTestCaseFilter", "vstestTestNames", "vstestTestFile", "environmentVariables", "vstestResultDir", "resultsfile"});
    private static final String DEFAULT_TEST_FILE = "testresults.trx";
    private static final String[] platforms = new String[]{"", "x86", "x64", "ARM"};
    private static final String[] frameworks = new String[]{"", "Framework35", "Framework40", "Framework45"};
    private static final String PLATFORMS = "platforms";
    private static final String FRAMEWORKS = "frameworks";
    private static final String DISCOVERERS = "discoverers";
    @Inject
    private CapabilitySetManager capabilitySetManager;

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String framework;
        String platform;
        String resultsFile;
        String testFile;
        String label = params.getString("label");
        if (StringUtils.isEmpty((CharSequence)label)) {
            errorCollection.addError("label", this.textProvider.getText("vstest.label.error"));
        }
        if (StringUtils.isEmpty((CharSequence)(testFile = params.getString("vstestTestFile")))) {
            errorCollection.addError("vstestTestFile", this.textProvider.getText("vstest.requires.testfile"));
        }
        if (StringUtils.isEmpty((CharSequence)(resultsFile = params.getString("resultsfile")))) {
            errorCollection.addError("resultsfile", this.textProvider.getText("vstest.resultsFile.error"));
        }
        if (StringUtils.isNotBlank((CharSequence)resultsFile) && !resultsFile.endsWith(".trx")) {
            errorCollection.addError("resultsfile", this.textProvider.getText("vstest.resultsFile.missingExtension"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(platform = params.getString("vstestPlatform"))) && !ArrayUtils.contains((Object[])platforms, (Object)platform)) {
            errorCollection.addError("vstestPlatform", this.textProvider.getText("vstest.invalid.platform"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(framework = params.getString("vstestFramework"))) && !ArrayUtils.contains((Object[])frameworks, (Object)framework)) {
            errorCollection.addError("vstestFramework", this.textProvider.getText("vstest.invalid.framework"));
        }
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job job) {
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        this.taskConfiguratorHelper.addSystemRequirementFromConfiguration(requirements, taskDefinition, "label", "system.builder.vstestconsole");
        List<String> discoverers = this.getDiscoverKeysFromTaskDefinition(taskDefinition);
        Map config = taskDefinition.getConfiguration();
        for (String discoverer : discoverers) {
            requirements.add((Requirement)new RequirementImpl((String)config.get(discoverer), true, ".*", true));
        }
        return requirements;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return true;
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(PLATFORMS, platforms);
        context.put(FRAMEWORKS, frameworks);
        context.put(DISCOVERERS, this.getTestDiscoverers());
        context.put("resultsfile", DEFAULT_TEST_FILE);
        context.put("vstestInIsolation", true);
        context.put("vstestFramework", "");
        context.put("vstestPlatform", "");
        context.put("vstestTestDiscoverers", new String[0]);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition);
        context.put(PLATFORMS, platforms);
        context.put(FRAMEWORKS, frameworks);
        context.put(DISCOVERERS, this.getTestDiscoverers());
    }

    private void populateContextWithConfiguration(Map<String, Object> context, TaskDefinition taskDefinition) {
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        List<String> discoverKeys = this.getDiscoverKeysFromTaskDefinition(taskDefinition);
        Map config = taskDefinition.getConfiguration();
        ArrayList discoverers = new ArrayList();
        for (String key : discoverKeys) {
            discoverers.add(config.get(key));
        }
        context.put("vstestTestDiscoverers", discoverers);
    }

    private List<String> getDiscoverKeysFromTaskDefinition(TaskDefinition taskDefinition) {
        return taskDefinition.getConfiguration().keySet().stream().filter(key -> key.startsWith("vstestTestDiscoverers")).collect(Collectors.toList());
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map map = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(map, params, FIELDS_TO_COPY);
        int index = 0;
        String[] discoverers = params.getStringArray("vstestTestDiscoverers");
        if (discoverers != null) {
            for (String s : discoverers) {
                map.put("vstestTestDiscoverers" + Integer.toString(index), s);
                ++index;
            }
        }
        return map;
    }

    private Map<String, String> getTestDiscoverers() {
        return this.capabilitySetManager.getSystemCapabilityKeys("vstestdiscoverer", false).stream().collect(Collectors.toMap(Function.identity(), VSTestDiscoverCapabilityTypeModule::constructLabel));
    }
}

