/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.mstest;

import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugin.dotnet.tests.mstest.MSTestTestReportCollector;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MSTestRunnerTaskType
implements TaskType {
    public static final String LABEL = "label";
    public static final String RUN_CONFIG = "mstestRunConfig";
    public static final String CONTAINER = "mstestContainer";
    public static final String RESULTS_FILE = "resultsfile";
    public static final String TEST_METADATA = "testmetadata";
    public static final String ENVIRONMENT = "environmentVariables";
    private final ProcessService processService;
    private final TestCollationService testCollationService;
    private final CapabilityContext capabilityContext;
    private final EnvironmentVariableAccessor environmentVariableAccessor;

    public MSTestRunnerTaskType(ProcessService processService, TestCollationService testCollationService, CapabilityContext capabilityContext, EnvironmentVariableAccessor environmentVariableAccessor) {
        this.processService = processService;
        this.testCollationService = testCollationService;
        this.capabilityContext = capabilityContext;
        this.environmentVariableAccessor = environmentVariableAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) {
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        taskContext.getBuildLogger().getInterceptorStack().add((LogInterceptor)errorLines);
        try {
            ConfigurationMap configuration = taskContext.getConfigurationMap();
            String label = (String)configuration.get((Object)LABEL);
            Preconditions.checkNotNull((Object)label, (Object)"You must select a Visual Studio executable before this task can execute.");
            String runConfig = (String)configuration.get((Object)RUN_CONFIG);
            Preconditions.checkNotNull((Object)runConfig, (Object)"Run Configuration");
            String container = (String)configuration.get((Object)CONTAINER);
            String testMetadata = (String)configuration.get((Object)TEST_METADATA);
            String resultsfile = (String)configuration.get((Object)RESULTS_FILE);
            Preconditions.checkNotNull((Object)resultsfile, (Object)"Results File Name");
            Capability capability = this.capabilityContext.getCapabilitySet().getCapability("system.builder.devenv." + label);
            Preconditions.checkNotNull((Object)capability, (Object)"Capability");
            File msTestExe = new File(capability.getValue(), "MSTest.exe");
            Preconditions.checkArgument((boolean)msTestExe.exists(), (Object)(msTestExe.getAbsolutePath() + " cannot be found"));
            ArrayList<String> command = new ArrayList<String>();
            command.add(msTestExe.getAbsolutePath());
            if (StringUtils.isNotEmpty((CharSequence)container)) {
                command.add("/testcontainer:" + container);
            } else if (StringUtils.isNotEmpty((CharSequence)testMetadata)) {
                command.add("/testmetadata:" + testMetadata);
            } else {
                throw new IllegalStateException("Configuration is not valid. Neither a Test Container or a path to a Test Metadata file were specified");
            }
            command.add("/resultsfile:" + resultsfile);
            if (StringUtils.isNotEmpty((CharSequence)runConfig)) {
                command.add("/runconfig:" + runConfig);
            }
            String environment = (String)configuration.get((Object)ENVIRONMENT);
            Map env = this.environmentVariableAccessor.splitEnvironmentAssignments(environment);
            ExternalProcess externalProcess = this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().command(command).env(env).workingDirectory(taskContext.getWorkingDirectory()));
            this.testCollationService.collateTestResults(taskContext, resultsfile, (TestReportCollector)new MSTestTestReportCollector());
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkTestFailures().checkReturnCode(externalProcess).build();
            return taskResult;
        }
        finally {
            taskContext.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }
}

