/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.visualstudio;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisualStudioCapabilityDefaultsHelper
implements CapabilityDefaultsHelper {
    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySet) {
        if (SystemUtils.IS_OS_WINDOWS) {
            String vs2008Location = System.getenv("VS90COMNTOOLS");
            String vs2010Location = System.getenv("VS100COMNTOOLS");
            String vs2012Location = System.getenv("VS110COMNTOOLS");
            String vs2013Location = System.getenv("VS120COMNTOOLS");
            this.createCapabilityForVisualStudio("Visual Studio 2008", capabilitySet, vs2008Location);
            this.createCapabilityForVisualStudio("Visual Studio 2010", capabilitySet, vs2010Location);
            this.createCapabilityForVisualStudio("Visual Studio 2012", capabilitySet, vs2012Location);
            this.createCapabilityForVisualStudio("Visual Studio 2013", capabilitySet, vs2013Location);
        }
        return capabilitySet;
    }

    private void createCapabilityForVisualStudio(@NotNull String label, @NotNull CapabilitySet capabilitySet, @Nullable String path) {
        File file;
        if (StringUtils.isNotEmpty((CharSequence)path) && (file = new File(new File(path).getParentFile(), "IDE")).exists() && file.isDirectory()) {
            CapabilityImpl capability = new CapabilityImpl("system.builder.devenv." + label, file.getAbsolutePath());
            capabilitySet.addCapability((Capability)capability);
        }
    }
}

