/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.vstest;

import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugin.dotnet.tests.mstest.MSTestTestReportCollector;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.FileVisitor;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VSTestRunnerTaskType
implements TaskType {
    private static final Logger log = Logger.getLogger(VSTestRunnerTaskType.class);
    public static final String LABEL = "label";
    public static final String SETTINGS_FILE = "vstestSettings";
    public static final String ENABLECODECOVERAGE = "vstestEnableCodeCoverage";
    public static final String INISOLATION = "vstestInIsolation";
    public static final String PLATFORM = "vstestPlatform";
    public static final String FRAMEWORK = "vstestFramework";
    public static final String TESTCASEFILTER = "vstestTestCaseFilter";
    public static final String TESTNAMES = "vstestTestNames";
    public static final String TESTFILE = "vstestTestFile";
    public static final String DISCOVERERS = "vstestTestDiscoverers";
    public static final String RESULTS_FILE = "resultsfile";
    public static final String RESULTS_DIR = "vstestResultDir";
    public static final String ENVIRONMENT = "environmentVariables";
    public static final String VSTESTEXE_CAPABILITY_PREFIX = "system.builder.vstestconsole";
    public static final String VSTESTEXE = "vstest.console.exe";
    private final ProcessService processService;
    private final TestCollationService testCollationService;
    private final CapabilityContext capabilityContext;
    private final EnvironmentVariableAccessor environmentVariableAccessor;

    public VSTestRunnerTaskType(ProcessService processService, TestCollationService testCollationService, CapabilityContext capabilityContext, EnvironmentVariableAccessor environmentVariableAccessor) {
        this.processService = processService;
        this.testCollationService = testCollationService;
        this.capabilityContext = capabilityContext;
        this.environmentVariableAccessor = environmentVariableAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        taskContext.getBuildLogger().getInterceptorStack().add((LogInterceptor)errorLines);
        try {
            TaskResult taskResult;
            File test;
            ConfigurationMap configuration = taskContext.getConfigurationMap();
            String label = (String)configuration.get((Object)LABEL);
            Preconditions.checkNotNull((Object)label, (Object)"You must select a vstest.console executable before this task can execute.");
            String settingsFile = (String)configuration.get((Object)SETTINGS_FILE);
            Preconditions.checkNotNull((Object)settingsFile, (Object)"Settings File");
            String platform = (String)configuration.get((Object)PLATFORM);
            String framework = (String)configuration.get((Object)FRAMEWORK);
            String inIsolation = (String)configuration.get((Object)INISOLATION);
            String codeCoverage = (String)configuration.get((Object)ENABLECODECOVERAGE);
            String testFile = (String)configuration.get((Object)TESTFILE);
            Preconditions.checkNotNull((Object)testFile, (Object)"Test File");
            String resultsFile = (String)configuration.get((Object)RESULTS_FILE);
            Preconditions.checkNotNull((Object)resultsFile, (Object)"Results File Name");
            String resultsDir = (String)configuration.get((Object)RESULTS_DIR);
            Preconditions.checkNotNull((Object)resultsDir, (Object)"Results Directory Name");
            Capability capability = this.capabilityContext.getCapabilitySet().getCapability("system.builder.vstestconsole." + label);
            Preconditions.checkNotNull((Object)capability, (Object)"Capability");
            File vsTestExe = new File(capability.getValue());
            Preconditions.checkArgument((boolean)vsTestExe.exists(), (Object)(vsTestExe.getAbsolutePath() + " cannot be found"));
            ArrayList<String> command = new ArrayList<String>();
            command.add(vsTestExe.getAbsolutePath());
            if (StringUtils.isNotEmpty((CharSequence)inIsolation) && inIsolation.compareTo("true") == 0) {
                command.add("/InIsolation");
            }
            if (StringUtils.isNotEmpty((CharSequence)codeCoverage) && codeCoverage.compareTo("true") == 0) {
                command.add("/EnableCodeCoverage");
            }
            if (StringUtils.isNotEmpty((CharSequence)platform)) {
                command.add("/platform:" + platform);
            }
            if (StringUtils.isNotEmpty((CharSequence)framework)) {
                command.add("/framework:" + framework);
            }
            if (StringUtils.isNotEmpty((CharSequence)settingsFile)) {
                command.add("/Settings:" + settingsFile);
            }
            if (StringUtils.isNotEmpty((CharSequence)testFile)) {
                test = new File(testFile);
                if (!test.isAbsolute()) {
                    test = new File(taskContext.getWorkingDirectory(), testFile);
                }
            } else {
                throw new IllegalStateException("Configuration is not valid. A Test File was not specified");
            }
            command.add(test.getPath());
            command.add("/logger:Trx");
            command.add("/UseVsixExtensions:true");
            String environment = (String)configuration.get((Object)ENVIRONMENT);
            Map env = this.environmentVariableAccessor.splitEnvironmentAssignments(environment);
            File tempDir = Files.createTempDir();
            try {
                ExternalProcess externalProcess = this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().command(command).env(env).workingDirectory(tempDir));
                this.publishToResultsDir(taskContext, resultsDir, resultsFile, tempDir);
                this.testCollationService.collateTestResults(taskContext, resultsDir, resultsFile, (TestReportCollector)new MSTestTestReportCollector(), false);
                taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkTestFailures().checkReturnCode(externalProcess).build();
            }
            catch (Throwable throwable) {
                try {
                    BambooPathUtils.deleteDirectory((Path)tempDir.toPath());
                }
                catch (IOException e) {
                    log.error((Object)("Unable to delete " + tempDir), (Throwable)e);
                }
                throw throwable;
            }
            try {
                BambooPathUtils.deleteDirectory((Path)tempDir.toPath());
            }
            catch (IOException e) {
                log.error((Object)("Unable to delete " + tempDir), (Throwable)e);
            }
            return taskResult;
        }
        finally {
            taskContext.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    private void publishToResultsDir(@NotNull TaskContext taskContext, @NotNull String resultDirPath, final @NotNull String resultFile, @NotNull File tempDir) throws TaskException {
        File resultsDir = new File(resultDirPath);
        if (!resultsDir.isAbsolute()) {
            resultsDir = new File(taskContext.getWorkingDirectory(), resultDirPath);
        }
        if (!resultsDir.exists() && !resultsDir.mkdirs()) {
            throw new TaskException("Unable to create results directory: " + resultDirPath);
        }
        final File resultDir = resultsDir;
        FileVisitor fileVisitor = new FileVisitor(tempDir){

            public void visitFile(File file) throws InterruptedException {
                try {
                    if (FilenameUtils.isExtension((String)file.getName(), (String)"trx")) {
                        FileUtils.copyFile((File)file, (File)new File(resultDir, resultFile), (boolean)true);
                    } else {
                        FileUtils.copyFile((File)file, (File)new File(resultDir, file.getName()), (boolean)true);
                    }
                }
                catch (IOException exception) {
                    throw new InterruptedException(exception.toString());
                }
            }
        };
        try {
            fileVisitor.visitFilesThatMatch("**/*");
        }
        catch (InterruptedException e) {
            log.error((Object)e.toString());
            log.error((Object)taskContext.getBuildLogger().addErrorLogEntry("Failed to publish test result files to results directory. Build was interrupted."));
        }
    }
}

