/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.nunit;

import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugin.dotnet.tests.nunit.NUnitTestReportCollector;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class NUnitRunnerTaskType
implements TaskType {
    public static final String NUNIT_SHORT_KEY = "nunit";
    public static final String NUNIT3_SHORT_KEY = "nunit3";
    public static final String NUNIT_CAPABILITY_PREFIX = "system.builder.nunit";
    public static final String NUNIT3_CAPABILITY_PREFIX = "system.builder.nunit3";
    public static final String CAPABILITY_KEY = "label";
    public static final String TEST_FILES = "nunitTestFiles";
    public static final String RESULTS_FILE = "nunitResultsFile";
    public static final String TESTS_TO_RUN = "run";
    public static final String INCLUDED_TEST_CATEGORIES = "include";
    public static final String EXCLUDED_TEST_CATEGORIES = "exclude";
    public static final String COMMAND_OPTIONS = "commandLineOptions";
    public static final String ENVIRONMENT = "environmentVariables";
    static final String WHERE_PARAMETER = "--where";
    static final String INCLUDE_PARAMETER = "-include=";
    static final String EXCLUDE_PARAMETER = "-exclude=";
    private final ProcessService processService;
    private final TestCollationService testCollationService;
    private final CapabilityContext capabilityContext;
    private final EnvironmentVariableAccessor environmentVariableAccessor;

    public NUnitRunnerTaskType(ProcessService processService, TestCollationService testCollationService, CapabilityContext capabilityContext, EnvironmentVariableAccessor environmentVariableAccessor) {
        this.processService = processService;
        this.testCollationService = testCollationService;
        this.capabilityContext = capabilityContext;
        this.environmentVariableAccessor = environmentVariableAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) {
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        taskContext.getBuildLogger().getInterceptorStack().add((LogInterceptor)errorLines);
        try {
            ConfigurationMap configuration = taskContext.getConfigurationMap();
            String resultsFile = (String)configuration.get((Object)RESULTS_FILE);
            Preconditions.checkNotNull((Object)resultsFile, (Object)"Results File Name");
            List<String> command = this.getCommand(configuration, resultsFile);
            String environment = (String)configuration.get((Object)ENVIRONMENT);
            Map env = this.environmentVariableAccessor.splitEnvironmentAssignments(environment);
            ExternalProcess externalProcess = this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().env(env).command(command).workingDirectory(taskContext.getWorkingDirectory()));
            this.testCollationService.collateTestResults(taskContext, resultsFile, (TestReportCollector)new NUnitTestReportCollector());
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkTestFailures().checkReturnCode(externalProcess).build();
            return taskResult;
        }
        finally {
            taskContext.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    @VisibleForTesting
    @NotNull
    List<String> getCommand(ConfigurationMap configuration, String resultsFile) {
        String testFiles = (String)configuration.get((Object)TEST_FILES);
        Preconditions.checkNotNull((Object)testFiles, (Object)"One or more test files must be specified");
        String capabilityKeyOrLabel = (String)configuration.get((Object)CAPABILITY_KEY);
        Preconditions.checkNotNull((Object)capabilityKeyOrLabel, (Object)"You must select an NUnit Runner before this task can execute.");
        String capabilityKey = NUnitRunnerTaskType.getCapabilityKey(capabilityKeyOrLabel);
        Capability capability = this.capabilityContext.getCapabilitySet().getCapability(capabilityKey);
        Preconditions.checkNotNull((Object)capability, (Object)"Capability");
        boolean isNunit3 = capabilityKey.startsWith(NUNIT3_CAPABILITY_PREFIX);
        File nunitConsoleExe = new File(capability.getValue());
        Preconditions.checkArgument((boolean)nunitConsoleExe.exists(), (Object)("NUnit Console Executable " + nunitConsoleExe + " not found"));
        ArrayList<String> command = new ArrayList<String>();
        command.add(nunitConsoleExe.getAbsolutePath());
        String testsToRun = (String)configuration.get((Object)TESTS_TO_RUN);
        if (StringUtils.isNotBlank((CharSequence)testsToRun)) {
            command.add("-run=" + testsToRun);
        }
        command.add(testFiles);
        command.add(this.getResultFileParameter(resultsFile, isNunit3));
        command.addAll(this.getIncludeExcludeCategories(configuration, isNunit3));
        command.addAll(CommandlineStringUtils.tokeniseCommandline((String)((String)configuration.get((Object)COMMAND_OPTIONS))));
        return command;
    }

    private List<String> getIncludeExcludeCategories(ConfigurationMap configuration, boolean isNunit3) {
        String includedCategories = (String)configuration.get((Object)INCLUDED_TEST_CATEGORIES);
        String excludedCategories = (String)configuration.get((Object)EXCLUDED_TEST_CATEGORIES);
        if (isNunit3) {
            return this.getWhereParameter(includedCategories, excludedCategories);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)includedCategories)) {
            result.add(INCLUDE_PARAMETER + includedCategories);
        }
        if (StringUtils.isNotBlank((CharSequence)excludedCategories)) {
            result.add(EXCLUDE_PARAMETER + excludedCategories);
        }
        return result;
    }

    private String getResultFileParameter(String resultsFile, boolean isNunit3) {
        if (isNunit3) {
            return "--result=" + resultsFile + ";format=nunit2";
        }
        return "-xml=" + resultsFile;
    }

    private List<String> getWhereParameter(String includedCategories, String excludedCategories) {
        StringBuilder whereClause = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)includedCategories)) {
            whereClause.append("cat==").append(includedCategories);
        }
        if (StringUtils.isNotBlank((CharSequence)excludedCategories)) {
            if (whereClause.length() > 0) {
                whereClause.append(" && ");
            }
            whereClause.append("cat!=").append(excludedCategories);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (whereClause.length() > 0) {
            result.add(WHERE_PARAMETER);
            result.add("\"" + whereClause.toString() + "\"");
        }
        return result;
    }

    @NotNull
    static String getCapabilityKey(String capabilityKeyOrLabel) {
        return capabilityKeyOrLabel.startsWith(NUNIT_CAPABILITY_PREFIX) ? capabilityKeyOrLabel : "system.builder.nunit." + capabilityKeyOrLabel;
    }
}

