/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.mbunit;

import com.atlassian.bamboo.plugin.dotnet.tests.TestResultContentHandler;
import com.atlassian.bamboo.plugin.dotnet.tests.TestResultsParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.security.xml.libs.SecureDom4jFactory;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.jcip.annotations.NotThreadSafe;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MBUnitXmlTestResultsParser
extends TestResultContentHandler
implements TestResultsParser {
    private static final Logger log = LoggerFactory.getLogger(MBUnitXmlTestResultsParser.class);
    private String testName;
    private List<TestResults> failedTests;
    private List<TestResults> inconclusiveTests;
    private List<TestResults> passedTests;
    private String systemOut;
    private String errorOut;

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public boolean hasErrors() {
        return this.getNumberOfErrors() > 0;
    }

    public int getNumberOfErrors() {
        return this.failedTests.size();
    }

    public int getNumberOfTests() {
        return this.failedTests.size() + this.passedTests.size();
    }

    @Override
    public ImmutableList<TestResults> getSuccessfulTests() {
        return ImmutableList.copyOf(this.passedTests);
    }

    @Override
    public ImmutableList<TestResults> getFailedTests() {
        return ImmutableList.copyOf(this.failedTests);
    }

    @Override
    public ImmutableList<TestResults> getInconclusiveTests() {
        return ImmutableList.copyOf(this.inconclusiveTests);
    }

    public String getSystemOut() {
        return this.systemOut;
    }

    public String getSystemErr() {
        return this.errorOut;
    }

    @Override
    public void parse(InputStream inputStream) {
        this.failedTests = new ArrayList<TestResults>();
        this.inconclusiveTests = new ArrayList<TestResults>();
        this.passedTests = new ArrayList<TestResults>();
        try {
            Map<String, String> uris = Collections.singletonMap("g", "http://www.gallio.org/");
            DocumentFactory factory = new DocumentFactory();
            factory.setXPathNamespaceURIs(uris);
            SAXReader reader = SecureDom4jFactory.newSaxReader();
            reader.setDocumentFactory(factory);
            Document document = reader.read(inputStream);
            this.parse(document);
        }
        catch (Exception e) {
            log.error("Failed to parse xml test results.", (Throwable)e);
        }
    }

    private void parse(Document document) {
        this.parsePreThreeZeroFiveFormat(document);
        this.parseThreeZeroFiveFormat(document);
    }

    private void parseThreeZeroFiveFormat(Document document) {
        List testStepRuns = document.selectNodes("//g:testStepRun[g:testStep/g:metadata/g:entry/g:value/text()='Fixture']");
        for (Object object : testStepRuns) {
            Node testStepRun = (Node)object;
            String fixtureName = testStepRun.selectSingleNode("g:testStep/g:codeReference/@type").getStringValue();
            List runs = testStepRun.selectNodes("g:children/g:testStepRun");
            for (Object runObject : runs) {
                Node run = (Node)runObject;
                String testName = run.selectSingleNode("g:testStep/@name").getStringValue();
                String testDuration = run.selectSingleNode("g:result/@duration").getStringValue();
                String result = run.selectSingleNode("g:result/g:outcome/@status").getStringValue();
                TestResults testResult = new TestResults(fixtureName, testName, testDuration);
                if ("passed".equalsIgnoreCase(result)) {
                    testResult.setState(TestState.SUCCESS);
                    this.passedTests.add(testResult);
                    continue;
                }
                if ("failed".equalsIgnoreCase(result)) {
                    InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/atlassian/bamboo/plugin/dotnet/tests/mbunit/Gallio-Report.txt.xsl");
                    StreamSource source = new StreamSource(inputStream);
                    Document newDocument = DocumentFactory.getInstance().createDocument();
                    newDocument.add(run.detach());
                    try {
                        testResult.addError((TestCaseResultError)new TestCaseResultErrorImpl(this.transform((Node)newDocument, source)));
                    }
                    catch (Exception e) {
                        log.error("Failed to transform the document", (Throwable)e);
                    }
                    testResult.setState(TestState.FAILED);
                    this.failedTests.add(testResult);
                    continue;
                }
                if ("skipped".equalsIgnoreCase(result)) {
                    testResult.setState(TestState.SKIPPED);
                    this.inconclusiveTests.add(testResult);
                    continue;
                }
                log.info("Skipping testStepRun node with status {}", (Object)result);
            }
        }
    }

    private void parsePreThreeZeroFiveFormat(Document document) {
        List fixtures = document.selectNodes("//fixture");
        for (Object object : fixtures) {
            Node fixtureNode = (Node)object;
            String fixtureName = fixtureNode.selectSingleNode("@name").getStringValue();
            List runs = fixtureNode.selectNodes("//run");
            for (Object runObject : runs) {
                Node run = (Node)runObject;
                String fqTestName = run.selectSingleNode("@name").getStringValue();
                String testName = fqTestName.contains(".") && !fqTestName.endsWith(".") ? fqTestName.substring(fqTestName.lastIndexOf(".") + 1) : fqTestName;
                String testDuration = run.selectSingleNode("@duration").getStringValue();
                String result = run.selectSingleNode("@result").getStringValue();
                if (result == null) continue;
                TestResults testResult = new TestResults(fixtureName, testName, testDuration);
                if ("success".equalsIgnoreCase(result)) {
                    testResult.setState(TestState.SUCCESS);
                    this.passedTests.add(testResult);
                    continue;
                }
                if ("failure".equalsIgnoreCase(result)) {
                    Node messageNode;
                    Node exceptionNode = run.selectSingleNode("exception");
                    if (exceptionNode != null && (messageNode = exceptionNode.selectSingleNode("message")) != null) {
                        testResult.addError((TestCaseResultError)new TestCaseResultErrorImpl(messageNode.getStringValue()));
                    }
                    testResult.setState(TestState.FAILED);
                    this.failedTests.add(testResult);
                    continue;
                }
                if ("ignore".equalsIgnoreCase(result)) {
                    testResult.setState(TestState.SKIPPED);
                    this.inconclusiveTests.add(testResult);
                    continue;
                }
                log.info("Skipping run node with result {}", (Object)result);
            }
        }
    }

    public String getErrorOut() {
        return this.errorOut;
    }

    public void setErrorOut(String errorOut) {
        this.errorOut = errorOut;
    }

    public void setSystemOut(String systemOut) {
        this.systemOut = systemOut;
    }

    public String transform(Node node, Source styleSheet) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(styleSheet);
        DocumentSource source = new DocumentSource(node);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        transformer.transform((Source)source, result);
        return out.toString();
    }
}

