/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.msbuild;

import com.atlassian.bamboo.configuration.external.helpers.ExecutableLabelValidator;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.MsBuildTask;
import com.atlassian.bamboo.specs.model.task.MsBuildTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MsBuildTaskExporter
implements TaskDefinitionExporter {
    private static final ValidationContext CONTEXT = ValidationContext.of((String)"MsBuild task");
    private final ExecutableLabelValidator executableLabelValidator;

    @Inject
    public MsBuildTaskExporter(ExecutableLabelValidator executableLabelValidator) {
        this.executableLabelValidator = executableLabelValidator;
    }

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        MsBuildTaskProperties msBuildTaskProperties = (MsBuildTaskProperties)Narrow.downTo((Object)taskProperties, MsBuildTaskProperties.class);
        if (msBuildTaskProperties == null) {
            throw new IllegalStateException("Unsupported import task of type: " + taskProperties.getClass().getName());
        }
        HashMap<String, String> cfg = new HashMap<String, String>();
        cfg.put("label", msBuildTaskProperties.getExecutable());
        cfg.put("solution", msBuildTaskProperties.getProjectFile());
        cfg.put("options", msBuildTaskProperties.getOptions());
        cfg.put("environmentVariables", msBuildTaskProperties.getEnvironmentVariables());
        cfg.put("workingSubDirectory", msBuildTaskProperties.getWorkingSubdirectory());
        return cfg;
    }

    @NotNull
    public MsBuildTask toSpecsEntity(TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        MsBuildTask task = new MsBuildTask().executable((String)configuration.get("label")).projectFile((String)configuration.get("solution")).options((String)configuration.get("options")).environmentVariables((String)configuration.get("environmentVariables")).workingSubdirectory((String)configuration.get("workingSubDirectory"));
        return task;
    }

    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        ArrayList<ValidationProblem> result = new ArrayList<ValidationProblem>();
        MsBuildTaskProperties properties = (MsBuildTaskProperties)Narrow.downTo((Object)taskProperties, MsBuildTaskProperties.class);
        if (properties == null) {
            return result;
        }
        String executableLabel = properties.getExecutable();
        if (StringUtils.isEmpty((CharSequence)executableLabel)) {
            result.add(new ValidationProblem(CONTEXT, "Executable can't be empty"));
        } else {
            this.executableLabelValidator.validateExecutableLabelExists(CONTEXT, executableLabel, "msbuild").ifPresent(result::add);
        }
        return result;
    }
}

