/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.visualstudio;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.spring.container.LazyComponentReference;
import com.atlassian.util.concurrent.LazyReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class RunnerExtractor {
    private static final Logger log = Logger.getLogger(RunnerExtractor.class);
    private static final LazyComponentReference<BuildDirectoryManager> BUILD_DIRECTORY_MANAGER_REFERENCE = new LazyComponentReference("buildDirectoryManager");
    private static final LazyReference<String> DOTNET_RUNNERS_HOME = new LazyReference<String>(){

        protected String create() throws Exception {
            File file = new File(((BuildDirectoryManager)BUILD_DIRECTORY_MANAGER_REFERENCE.get()).getApplicationHome(), "DotNetSupport");
            file.mkdirs();
            return file.getAbsolutePath();
        }
    };
    private static final LazyReference<String> DEVENV_RUNNER_REFERENCE = new LazyReference<String>(){

        protected String create() throws Exception {
            return RunnerExtractor.extract("/com/atlassian/bamboo/plugin/dotnet/visualstudio/devenvrunner.bat", "devenvrunner.bat");
        }
    };

    private RunnerExtractor() {
    }

    public static String getDevenvRunnerPath() {
        return (String)DEVENV_RUNNER_REFERENCE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String extract(@NotNull String resourceName, String filename) throws IOException {
        String string;
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = RunnerExtractor.class.getResourceAsStream(resourceName);
            if (inputStream == null) {
                throw new IllegalStateException("Could not find '" + resourceName + "' on classpath");
            }
            File file = new File((String)DOTNET_RUNNERS_HOME.get(), filename);
            outputStream = new FileOutputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            string = file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return string;
    }
}

