/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.nunit;

import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.TestParserTask;
import com.atlassian.bamboo.specs.model.task.TestParserTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class NUnitCollectorTaskExporter
implements TaskDefinitionExporter {
    private static final ValidationContext NUNIT_PARSER_CONTEXT = ValidationContext.of((String)"NUnit parser task");

    @NotNull
    public TestParserTask toSpecsEntity(TaskDefinition taskDefinition) {
        String pickupOutdatedFiles;
        TestParserTask testParserTask = TestParserTask.createNUnitParserTask();
        Map configuration = taskDefinition.getConfiguration();
        String testDirectory = (String)configuration.get("testResultsDirectory");
        if (!StringUtils.isEmpty((CharSequence)testDirectory)) {
            Splitter.on((char)',').trimResults().split((CharSequence)testDirectory).forEach(xva$0 -> testParserTask.resultDirectories(new String[]{xva$0}));
        }
        if (!StringUtils.isEmpty((CharSequence)(pickupOutdatedFiles = (String)configuration.get("pickupOutdatedFiles")))) {
            testParserTask.pickUpTestResultsCreatedOutsideOfThisBuild(Boolean.valueOf(pickupOutdatedFiles));
        }
        return testParserTask;
    }

    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, TaskProperties taskProperties) {
        TestParserTaskProperties testParserTaskProperties = (TestParserTaskProperties)Narrow.downTo((Object)taskProperties, TestParserTaskProperties.class);
        if (testParserTaskProperties != null) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            if (testParserTaskProperties.getResultDirectories() != null) {
                cfg.put("testResultsDirectory", this.getResultPath(testParserTaskProperties));
            }
            cfg.put("pickupOutdatedFiles", Boolean.toString(testParserTaskProperties.getPickUpTestResultsCreatedOutsideOfThisBuild()));
            return cfg;
        }
        throw new IllegalStateException("Don't know how to import task properties of type: " + taskProperties.getClass().getName());
    }

    private String getResultPath(TestParserTaskProperties testParserTaskProperties) {
        return testParserTaskProperties.getResultDirectories().stream().collect(Collectors.joining(","));
    }

    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        ArrayList<ValidationProblem> result = new ArrayList<ValidationProblem>();
        TestParserTaskProperties testParserTaskProperties = (TestParserTaskProperties)Narrow.downTo((Object)taskProperties, TestParserTaskProperties.class);
        if (testParserTaskProperties != null && StringUtils.isEmpty((CharSequence)this.getResultPath(testParserTaskProperties))) {
            result.add(new ValidationProblem(NUNIT_PARSER_CONTEXT, "Result path is mandatory"));
        }
        return result;
    }
}

