/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.mstest;

import com.atlassian.bamboo.plugin.dotnet.tests.TestResultContentHandler;
import com.atlassian.bamboo.plugin.dotnet.tests.TestResultsParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.NotThreadSafe;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class MSTestXmlTestResultsParser
extends TestResultContentHandler
implements TestResultsParser {
    private static final Logger log = Logger.getLogger(MSTestXmlTestResultsParser.class);
    private List<TestResults> failedTests;
    private List<TestResults> inconclusiveTests;
    private List<TestResults> passedTests;
    private static final String VS_2006_PREFIX = "a";
    private static final String VS_2010_PREFIX = "b";
    private static final Pattern DURATION_FORMAT = Pattern.compile("(\\d{2}):(\\d{2}):(\\d{2})\\.(\\d{3})\\d+");

    @Override
    public void parse(InputStream inputStream) {
        log.info((Object)"Beginning parse of MSTest results file");
        this.failedTests = new ArrayList<TestResults>();
        this.passedTests = new ArrayList<TestResults>();
        this.inconclusiveTests = new ArrayList<TestResults>();
        try {
            ImmutableMap uris = ImmutableMap.of((Object)VS_2006_PREFIX, (Object)"http://microsoft.com/schemas/VisualStudio/TeamTest/2006", (Object)VS_2010_PREFIX, (Object)"http://microsoft.com/schemas/VisualStudio/TeamTest/2010");
            DocumentFactory factory = new DocumentFactory();
            factory.setXPathNamespaceURIs((Map)uris);
            SAXReader reader = new SAXReader();
            reader.setDocumentFactory(factory);
            Document document = reader.read(inputStream);
            this.parse(document);
            log.info((Object)"Finished parse of MSTest results file");
        }
        catch (Exception e) {
            log.error((Object)"Failed to parse xml test results. File was null.", (Throwable)e);
        }
    }

    private static String getContent(Element element) {
        if (element.isTextOnly()) {
            return element.getText();
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            sb.append(((Element)iterator.next()).asXML());
        }
        return sb.toString();
    }

    private void parse(Document document) {
        String namespacePrefix = "";
        List results = document.selectNodes("//Results/*");
        if (results.isEmpty()) {
            results = this.getVS2006Results(document);
            namespacePrefix = "a:";
        }
        if (results.isEmpty()) {
            results = this.getVS2010Results(document);
            namespacePrefix = "b:";
        }
        Map<String, Node> unitTestNodes = MSTestXmlTestResultsParser.cacheUnitTestNodes((Node)document, namespacePrefix);
        for (Object object : results) {
            String result;
            String testName;
            Node testNode = (Node)object;
            String className = testName = testNode.selectSingleNode("@testName").getStringValue();
            String objectId = testNode.selectSingleNode("@testId").getStringValue();
            Node unitTestNode = unitTestNodes.get(objectId);
            if (unitTestNode != null) {
                className = unitTestNode.selectSingleNode(namespacePrefix + "TestMethod/@className").getStringValue();
                className = className.split(",")[0];
            }
            Long testDuration = this.parseDuration(testNode).map(Duration::toMillis).orElse(null);
            Node outcomeAttr = testNode.selectSingleNode("@outcome");
            String string = result = outcomeAttr != null ? outcomeAttr.getStringValue() : "Failed";
            if (result == null) continue;
            TestResults testResult = new TestResults(className, testName, testDuration);
            Node stdOutData = testNode.selectSingleNode(namespacePrefix + "Output/" + namespacePrefix + "StdOut");
            if (stdOutData != null && stdOutData.hasContent()) {
                Element e = (Element)stdOutData;
                testResult.setSystemOut(MSTestXmlTestResultsParser.getContent(e));
            }
            if (result.equalsIgnoreCase("Passed")) {
                testResult.setState(TestState.SUCCESS);
                this.passedTests.add(testResult);
                continue;
            }
            if (result.equalsIgnoreCase("Ignored")) {
                testResult.setState(TestState.SKIPPED);
                this.inconclusiveTests.add(testResult);
                continue;
            }
            Optional<TestCaseResultError> error = this.parseError(testNode, namespacePrefix);
            error.ifPresent(arg_0 -> ((TestResults)testResult).addError(arg_0));
            if (result.equalsIgnoreCase("Inconclusive")) {
                testResult.setState(TestState.SKIPPED);
                this.inconclusiveTests.add(testResult);
                continue;
            }
            if (result.equalsIgnoreCase("NotExecuted")) {
                testResult.setState(TestState.SKIPPED);
                this.inconclusiveTests.add(testResult);
                continue;
            }
            testResult.setState(TestState.FAILED);
            this.failedTests.add(testResult);
        }
    }

    @NotNull
    private static Map<String, Node> cacheUnitTestNodes(Node document, String namespacePrefix) {
        HashMap<String, Node> cachedTestInfo = new HashMap<String, Node>();
        List cachedNodes = document.selectNodes("//" + namespacePrefix + "UnitTest");
        for (Element e : cachedNodes) {
            cachedTestInfo.put(e.attributeValue("id"), (Node)e);
        }
        return cachedTestInfo;
    }

    private Optional<Duration> parseDuration(@NotNull Node testNode) {
        Node durationAttr = testNode.selectSingleNode("@duration");
        if (durationAttr != null) {
            return this.convertDuration(durationAttr.getStringValue());
        }
        return Optional.empty();
    }

    private Optional<TestCaseResultError> parseError(@NotNull Node testNode, @NotNull String namespacePrefix) {
        Node messageNode = this.getErrorMessageNode(testNode, namespacePrefix);
        if (messageNode != null) {
            return Optional.of(new TestCaseResultErrorImpl(messageNode.getStringValue()));
        }
        return Optional.empty();
    }

    @Nullable
    private Node getErrorMessageNode(@NotNull Node testNode, @NotNull String namespacePrefix) {
        if (namespacePrefix.equals(VS_2006_PREFIX)) {
            return testNode.selectSingleNode(namespacePrefix + "Output");
        }
        return testNode.selectSingleNode(namespacePrefix + "Output/" + namespacePrefix + "ErrorInfo/" + namespacePrefix + "Message");
    }

    private Optional<Duration> convertDuration(String input) {
        Matcher matcher = DURATION_FORMAT.matcher(input);
        if (matcher.matches()) {
            long hh = Long.parseLong(matcher.group(1));
            long mm = Long.parseLong(matcher.group(2));
            long ss = Long.parseLong(matcher.group(3));
            long ms = Long.parseLong(matcher.group(4));
            return Optional.of(Duration.ofHours(hh).plusMinutes(mm).plusSeconds(ss).plusMillis(ms));
        }
        log.warn((Object)String.format("Cannot parse duration string [%s]", input));
        return Optional.empty();
    }

    private List getVS2006Results(Document document) {
        return document.selectNodes("//a:Results/*");
    }

    private List getVS2010Results(Document document) {
        return document.selectNodes("//b:Results/*");
    }

    @Override
    public ImmutableList<TestResults> getSuccessfulTests() {
        return ImmutableList.copyOf(this.passedTests);
    }

    @Override
    public ImmutableList<TestResults> getFailedTests() {
        return ImmutableList.copyOf(this.failedTests);
    }

    @Override
    public ImmutableList<TestResults> getInconclusiveTests() {
        return ImmutableList.copyOf(this.inconclusiveTests);
    }
}

