/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.plugin.dotnet.tests.TestResultsParser;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public abstract class AbstractDotNetTestReportCollector
implements TestReportCollector {
    private static final Logger log = Logger.getLogger(AbstractDotNetTestReportCollector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TestCollectionResult collect(@NotNull File file) throws Exception {
        TestResultsParser testResultsParser = this.getParser();
        FileInputStream inputStream = new FileInputStream(file);
        try {
            testResultsParser.parse(inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return new TestCollectionResultBuilder().addSuccessfulTestResults(testResultsParser.getSuccessfulTests()).addFailedTestResults(testResultsParser.getFailedTests()).addSkippedTestResults(testResultsParser.getInconclusiveTests()).build();
    }

    @NotNull
    public Set<String> getSupportedFileExtensions() {
        return Sets.newHashSet((Object[])new String[]{"trx", "xml"});
    }

    @NotNull
    protected abstract TestResultsParser getParser();
}

