/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.msbuild;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MsBuildConfig {
    private static final Logger log = Logger.getLogger(MsBuildConfig.class);
    public static final String MSBUILD_EXECUTABLE_LABEL = "msbuild";
    public static final String MSBUILD_CAPABILITY_PREFIX = "system.builder.msbuild";
    public static final String LABEL = "label";
    public static final String SOLUTION = "solution";
    public static final String OPTIONS = "options";
    public static final String ENVIRONMENT = "environmentVariables";
    private final String msBuildExecutable;
    private final String options;
    private final String solution;
    private final Map<String, String> environmentMap;

    private MsBuildConfig(@NotNull String msBuildExecutable, @NotNull String options, @NotNull String solution, @NotNull Map<String, String> environmentMap) {
        this.msBuildExecutable = msBuildExecutable;
        this.options = options;
        this.solution = solution;
        this.environmentMap = environmentMap;
    }

    public static MsBuildConfig build(@NotNull CommonTaskContext taskContext, @NotNull CapabilityContext capabilityContext, @NotNull EnvironmentVariableAccessor environmentVariableAccessor) {
        ConfigurationMap configuration = taskContext.getConfigurationMap();
        String label = (String)configuration.get((Object)LABEL);
        Preconditions.checkNotNull((Object)label);
        String solution = (String)configuration.get((Object)SOLUTION);
        Preconditions.checkNotNull((Object)solution, (Object)"Solution");
        String options = (String)configuration.get((Object)OPTIONS);
        Preconditions.checkNotNull((Object)options, (Object)"Options");
        Map environmentMap = environmentVariableAccessor.splitEnvironmentAssignments((String)taskContext.getConfigurationMap().get((Object)ENVIRONMENT));
        Preconditions.checkNotNull((Object)environmentMap, (Object)"Process Environment");
        String capaName = "system.builder.msbuild." + label;
        Capability msBuildCapability = capabilityContext.getCapabilitySet().getCapability(capaName);
        Preconditions.checkNotNull((Object)msBuildCapability, (Object)("Capability " + capaName + " is missing"));
        String msBuildExecutable = msBuildCapability.getValue();
        Preconditions.checkNotNull((Object)msBuildExecutable, (Object)("Could not find MSBuild.exe, " + capaName + " point to nowhere"));
        String msBuildExecutableAbsolutePath = new File(msBuildExecutable).getAbsolutePath();
        return new MsBuildConfig(msBuildExecutableAbsolutePath, options, solution, environmentMap);
    }

    @NotNull
    public String getMsBuildExecutable() {
        return this.msBuildExecutable;
    }

    @NotNull
    public String getOptions() {
        return this.options;
    }

    @NotNull
    public String getSolution() {
        return this.solution;
    }

    @NotNull
    public Map<String, String> getEnvironmentMap() {
        return this.environmentMap;
    }
}

