/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.msbuild;

import com.atlassian.bamboo.plugin.dotnet.msbuild.WindowsSystemPaths;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MsBuildCapabilityDefaultsHelper
implements CapabilityDefaultsHelper {
    private static final Logger log = Logger.getLogger(MsBuildCapabilityDefaultsHelper.class);
    private static final Pattern IS_VERSION_NUMBER = Pattern.compile("[0-9.]+");

    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySet) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return capabilitySet;
        }
        MsBuildCapabilityDefaultsHelper.addMsBuildPre12Capability(capabilitySet);
        this.addMsBuild12PlusCapabilities(capabilitySet);
        return capabilitySet;
    }

    private void addMsBuild12PlusCapabilities(@NotNull CapabilitySet capabilitySet) {
        Optional<File> programFiles = WindowsSystemPaths.PROGRAM_FILES.get();
        programFiles.ifPresent(programFilesFolder -> {
            File msBuildDirectory = new File((File)programFilesFolder, "MSBuild");
            MsBuildCapabilityDefaultsHelper.processFrameworkDirForMsBuild12Plus(capabilitySet, msBuildDirectory);
        });
        Optional<File> programFilesX86 = WindowsSystemPaths.PROGRAM_FILES_X86.get();
        programFilesX86.ifPresent(programFilesX86Folder -> {
            if (!programFiles.isPresent() || !((File)programFiles.get()).getAbsoluteFile().equals(programFilesX86Folder.getAbsoluteFile())) {
                File msBuildDirectory = new File((File)programFilesX86Folder, "MSBuild");
                MsBuildCapabilityDefaultsHelper.processFrameworkDirForMsBuild12Plus(capabilitySet, msBuildDirectory);
            }
        });
    }

    private static void addMsBuildPre12Capability(@NotNull CapabilitySet capabilitySet) {
        WindowsSystemPaths.WINDOWS.get().ifPresent(windowsFolder -> {
            File netFramework32 = new File((File)windowsFolder, "\\Microsoft.NET\\Framework");
            MsBuildCapabilityDefaultsHelper.processFrameworkDirForMsBuildPre12(capabilitySet, netFramework32, DotNetFrameworkType.ARCH_32_BIT);
            File netFramework64 = new File((File)windowsFolder, "\\Microsoft.NET\\Framework64");
            MsBuildCapabilityDefaultsHelper.processFrameworkDirForMsBuildPre12(capabilitySet, netFramework64, DotNetFrameworkType.ARCH_64_BIT);
        });
    }

    private static void processFrameworkDirForMsBuildPre12(@NotNull CapabilitySet capabilitySet, @NotNull File frameworkDirectory, @NotNull DotNetFrameworkType dotNetFrameworkType) {
        MsBuildCapabilityDefaultsHelper.subdirectoriesOf(frameworkDirectory).filter(subDir -> subDir.getName().startsWith("v")).forEach(subDir -> MsBuildCapabilityDefaultsHelper.addMSBuildCapability(capabilitySet, subDir, dotNetFrameworkType));
    }

    private static void processFrameworkDirForMsBuild12Plus(@NotNull CapabilitySet capabilitySet, File frameworkDirectory) {
        MsBuildCapabilityDefaultsHelper.subdirectoriesOf(frameworkDirectory).filter(subDir -> IS_VERSION_NUMBER.matcher(subDir.getName()).matches()).forEach(subDir -> MsBuildCapabilityDefaultsHelper.processFrameworkSubdirFileSince12(capabilitySet, subDir));
    }

    private static void processFrameworkSubdirFileSince12(@NotNull CapabilitySet capabilitySet, File subDirectory) {
        File msBuildPath64;
        String frameworkVersion = subDirectory.getName();
        String friendlyVersion = frameworkVersion.length() >= 5 ? frameworkVersion.substring(0, 5) : frameworkVersion;
        String labelPrefix = "MSBuild v" + friendlyVersion;
        File msBuildPath32 = new File(subDirectory + "/bin", "MSBuild.exe");
        if (msBuildPath32.exists()) {
            MsBuildCapabilityDefaultsHelper.addMSBuilCapability(capabilitySet, msBuildPath32, labelPrefix + " (32bit)");
        }
        if ((msBuildPath64 = new File(subDirectory + "/bin/amd64", "MSBuild.exe")).exists()) {
            MsBuildCapabilityDefaultsHelper.addMSBuilCapability(capabilitySet, msBuildPath64, labelPrefix + " (64bit)");
        }
    }

    private static void addMSBuildCapability(@NotNull CapabilitySet capabilitySet, @NotNull File frameworkDirectory, @NotNull DotNetFrameworkType dotNetFrameworkType) {
        File msBuildPath = new File(frameworkDirectory, "MSBuild.exe");
        if (msBuildPath.exists()) {
            String frameworkVersion = frameworkDirectory.getName().substring(1);
            String friendlyVersion = frameworkVersion.length() >= 3 ? frameworkVersion.substring(0, 3) : frameworkVersion;
            String architecture = dotNetFrameworkType == DotNetFrameworkType.ARCH_64_BIT ? "64bit" : "32bit";
            String label = "MSBuild v" + friendlyVersion + " (" + architecture + ')';
            MsBuildCapabilityDefaultsHelper.addMSBuilCapability(capabilitySet, msBuildPath, label);
        }
    }

    private static void addMSBuilCapability(@NotNull CapabilitySet capabilitySet, @NotNull File msBuildPath, @NotNull String label) {
        CapabilityImpl capability = new CapabilityImpl("system.builder.msbuild." + label, msBuildPath.getAbsolutePath());
        capabilitySet.addCapability((Capability)capability);
    }

    private static Stream<File> subdirectoriesOf(File frameworkDirectory) {
        if (!frameworkDirectory.isDirectory()) {
            log.warn((Object)("Framework directory " + frameworkDirectory + " is not a directory"));
            return Stream.empty();
        }
        File[] files = frameworkDirectory.listFiles();
        if (files == null) {
            log.warn((Object)("Framework directory " + frameworkDirectory + " could not be listed"));
            return Stream.empty();
        }
        return Arrays.stream(files).filter(File::isDirectory);
    }

    private static enum DotNetFrameworkType {
        ARCH_32_BIT,
        ARCH_64_BIT;

    }
}

