/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.grails;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.TaskConfigConstants;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.xwork2.TextProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrailsTaskConfigurator
extends AbstractTaskConfigurator
implements BuildTaskRequirementSupport,
TaskTestResultsSupport {
    private static final Logger log = Logger.getLogger(GrailsTaskConfigurator.class);
    static final String GRAILS_CAPABILITY_PREFIX = "system.builder.grailsBuilder";
    static final String CFG_GOALS = "goals";
    private static final String CFG_TEST_RESULTS_FILE_PATTERN_OPTION_CUSTOM = "customTestDirectory";
    private static final String CFG_TEST_RESULTS_FILE_PATTERN_OPTION_STANDARD = "standardTestDirectory";
    private static final Map<String, String> TEST_RESULTS_FILE_PATTERN_TYPES = ImmutableMap.of((Object)"standardTestDirectory", (Object)"Look in the standard test results directory.", (Object)"customTestDirectory", (Object)"Specify custom results directories");
    private static final String CTX_TEST_RESULTS_FILE_PATTERN_TYPES = "testDirectoryTypes";
    private static final String DEFAULT_TEST_RESULTS_FILE_PATTERN = "**/*reports/*.xml";
    private static final String CTX_UI_CONFIG_SUPPORT = "uiConfigSupport";
    private static final String DEFAULT_GOAL = "clean\r\ntest-app";
    private static final List<String> FIELDS_TO_COPY = ImmutableList.of((Object)"goals");
    private TextProvider textProvider;
    private UIConfigSupport uiConfigSupport;

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job job) {
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        this.taskConfiguratorHelper.addJdkRequirement(requirements, taskDefinition, "buildJdk");
        this.taskConfiguratorHelper.addSystemRequirementFromConfiguration(requirements, taskDefinition, "label", GRAILS_CAPABILITY_PREFIX);
        return requirements;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        this.taskConfiguratorHelper.validateBuilderLabel(params, errorCollection);
        if (StringUtils.isEmpty((CharSequence)params.getString(CFG_GOALS))) {
            errorCollection.addError(CFG_GOALS, this.textProvider.getText("task.maven.validate.goals.mandatory"));
        }
        this.taskConfiguratorHelper.validateJdk(params, errorCollection);
        this.taskConfiguratorHelper.validateTestResultsFilePatternIfCustomPatternSelected(params, errorCollection, CFG_TEST_RESULTS_FILE_PATTERN_OPTION_CUSTOM);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, (Iterable)TaskConfigConstants.DEFAULT_BUILDER_CONFIGURATION_KEYS);
        if (CFG_TEST_RESULTS_FILE_PATTERN_OPTION_STANDARD.equals(params.getString("testDirectoryOption"))) {
            config.put("testResultsDirectory", DEFAULT_TEST_RESULTS_FILE_PATTERN);
        }
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, Arrays.asList(CFG_GOALS));
        return config;
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextForAllOperations(context);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, Iterables.concat((Iterable)TaskConfigConstants.DEFAULT_BUILDER_CONFIGURATION_KEYS, FIELDS_TO_COPY));
        context.put("hasTests", Boolean.valueOf((String)taskDefinition.getConfiguration().get("testChecked")));
        context.put(CTX_TEST_RESULTS_FILE_PATTERN_TYPES, TEST_RESULTS_FILE_PATTERN_TYPES);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateContextForAllOperations(context);
        context.put(CFG_GOALS, DEFAULT_GOAL);
        context.put(CTX_TEST_RESULTS_FILE_PATTERN_TYPES, TEST_RESULTS_FILE_PATTERN_TYPES);
        context.put("testDirectoryOption", CFG_TEST_RESULTS_FILE_PATTERN_OPTION_STANDARD);
        context.put("testResultsDirectory", DEFAULT_TEST_RESULTS_FILE_PATTERN);
        context.put("hasTests", Boolean.TRUE);
        context.put("testChecked", Boolean.TRUE);
        context.put("buildJdk", this.uiConfigSupport.getDefaultJdkLabel());
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return Boolean.parseBoolean((String)taskDefinition.getConfiguration().get("testChecked"));
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context) {
        context.put(CTX_UI_CONFIG_SUPPORT, this.uiConfigSupport);
        context.put(CTX_TEST_RESULTS_FILE_PATTERN_TYPES, TEST_RESULTS_FILE_PATTERN_TYPES);
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setUiConfigSupport(UIConfigSupport uiConfigSupport) {
        this.uiConfigSupport = uiConfigSupport;
    }
}

