define('branchinator/views/layout/content/landing-page-view', [
    'backbone',
    'branchinator/behaviors/fetch-state-aware-behavior',
    'branchinator/utils/branchinator-utils',
    'branchinator/utils/radio-utils',
    'branchinator/views/layout/content/landing-page-recent-branch-view',
    'jquery',
    'marionette'
], function(
    Backbone,
    FetchStateAwareBehavior,
    bnUtils,
    radioUtils,
    LandingPageRecentBranchView,
    $,
    Marionette
) {
    'use strict';

    var LandingPageRecentBranchesEmptyView = Marionette.ItemView.extend({
        tagName: 'li',

        template: function() {
            return bamboo.plugins.branchinator.renderLandingPageRecentBranchesEmptyView({
                fetched: this.getOption('isFetched')()
            });
        }
    });

    /**
     * View for displaying branch status landing page.
     *
     * Parameters:
     * - model - branch selection model
     * - collection - recent branches collection
     */
    return Marionette.CompositeView.extend({
        childView: LandingPageRecentBranchView,
        childViewContainer: 'ul.branchSuggestions',

        emptyView: LandingPageRecentBranchesEmptyView,
        emptyViewOptions: function() {
            return {
                isFetched: this.isFetched
            };
        },

        modelEvents: {
            'repo:cleared repo:selected branch:cleared branch:selected': 'fetchCollection'
        },

        childEvents: {
            'recent:branch:selected': 'onRecentBranchSelected'
        },

        behaviors: {
            FetchStateAware: {
                behaviorClass: FetchStateAwareBehavior
            }
        },

        template: function() {
            return bamboo.plugins.branchinator.renderLandingPageView();
        },

        initialize: function() {
            this.fetchCollection();
        },

        fetchCollection: function() {
            this.collection.fetch({ reset: true });
        },

        onInitialFetchComplete: function() {
            // re-render if the collection is empty, to change loading spinner into 'no branches' message
            if (this.collection.isEmpty()) {
                this.render();
            }
        },

        onRecentBranchSelected: function(args) {
            var eventModel = args.model;
            this.model.selectBranch(eventModel.get('repoId'), eventModel.get('repoName'), eventModel.get('branchName'));
        }
    });
});
