define('branchinator/views/layout/content/landing-page-recent-branch-view', [
    'branchinator/utils/branchinator-utils',
    'marionette'
], function(
    bnUtils,
    Marionette
) {
    'use strict';

    /**
     * View representing a single recently visited branch displayed on branch status landing page.
     *
     * Parameters:
     * - model - model from recent branches collection
     */
    return Marionette.ItemView.extend({
        tagName: 'li',

        ui: {
            branchSuggestion: '.branchSuggestion'
        },

        triggers: {
            'click @ui.branchSuggestion': 'recent:branch:selected'
        },

        template: function(data) {
            return bamboo.plugins.branchinator.renderLandingPageRecentBranchView({ recentBranch: data });
        },

        onRender: function() {
            // change URL of the link so if it's opened in new tab, it will point to preselected branch in branch status page
            var url = bnUtils.getRepoAndBranchUrlPath(this.model.get('repoId'), this.model.get('repoName'), this.model.get('branchName'));
            this.ui.branchSuggestion.attr('href', bnUtils.getApplicationRootUrl() + '/' + url);
            return this;
        }
    });
});
