define('branchinator/regions/header-region', [
    'marionette',
    'jquery'
], function(
    Marionette,
    $
) {
    'use strict';

    /**
     * Region of branch status page header.
     *
     * This region behaves differently as it prepends it's content to a known location on page. The '$el' is just a
     * temporary container.
     */
    return Marionette.Region.extend({
        attachHtml: function(view) {
            var $container = $('section#content');
            var headerId = $(view.el).attr('id');
            $container.find('#' + headerId).remove();
            $container.prepend(view.el);
            this.$el.hide();
        }
    });
});
