define('branchinator/models/branch-selection-model', [
    'backbone',
    'underscore'
], function(
    Backbone,
    _
) {
    'use strict';

    /**
     * Model for storing current status of repository and branch selection.
     *
     * Triggered events:
     * - repo:cleared
     * - repo:selected
     * - branch:cleared
     * - branch:selected
     */
    return Backbone.Model.extend({
        defaults: {
            repo: { id: 0, name: '' },
            branch: { repoId: 0, repoName: '', id: '', branchName: '' }
        },

        getRepoId: function() {
            return this.get('repo').id;
        },

        getRepoName: function() {
            return this.get('repo').name;
        },

        getBranchName: function() {
            return this.get('branch').branchName;
        },

        clearRepo: function() {
            if (this.get('repo').id > 0) {
                this.clearBranch();
                this.set('repo', this.defaults.repo);
                this.trigger('repo:cleared');
            }
        },

        selectRepo: function(id, name) {
            var newRepo = { id: id, name: name };
            if (!_.isEqual(this.get('repo'), newRepo)) {
                this.clearBranch();
                this.set('repo', newRepo);
                this.trigger('repo:selected', this.get('repo'));
            }
        },

        clearBranch: function() {
            if (this.get('branch').branchName) {
                this.set('branch', this.defaults.branch);
                this.trigger('branch:cleared', this.get('repo'));
            }
        },

        selectBranch: function(repoId, repoName, branchName) {
            var newBranch = { repoId: repoId, repoName: repoName, id: branchName, branchName: branchName };
            if (!_.isEqual(this.get('branch'), newBranch)) {
                this.set('repo', { id: repoId, name: repoName });
                this.set('branch', newBranch);
                this.trigger('branch:selected', {
                    repo: this.get('repo'),
                    branch: this.get('branch')
                });
            }
        }
    });
});
