define('branchinator/dialogs/build-commits-dialog', [
    'backbone',
    'branchinator/collections/build-commits-collection',
    'underscore',
    'widget/dialog'
], function(
    Backbone,
    BuildCommitsCollection,
    _,
    Dialog
) {
    'use strict';

    /**
     * Dialog with list of commits for latest build result of a plan.
     *
     * Parameters:
     * - planKey - key of plan or plan branch
     */
    return Dialog.extend({
        defaultSettings: {
            width: 800,
            height: 400,
            buttons: [{
                id: 'cancel',
                label: AJS.I18n.getText('global.buttons.close'),
                type: 'link',
                cssClass: 'close-commits-dialog'
            }]
        },

        initialize: function(options) {
            var settings = {
                header: AJS.I18n.getText("branchinator.commits.dialog.header", options.planKey),
                content: bamboo.plugins.branchinator.renderBigSpinner()
            };
            Dialog.prototype.initialize.call(this, _.defaults(settings, this.defaultSettings));

            this.collection = BuildCommitsCollection.forPlanKey(options.planKey);
            this.collection.on('sync', this.onCollectionSync, this);
            this.collection.on('error', this.onCollectionError, this);
            this.collection.fetch();
        },

        onCollectionSync: function() {
            this.$dialogContent.html(bamboo.plugins.branchinator.renderCommitsDialog({ commits: this.collection.toJSON() }));
        },

        onCollectionError: function() {
            this.$dialogContent.html(AJS.I18n.getText('branchinator.commits.dialog.error'));
        }
    });
});
