/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.util;

import com.atlassian.bamboo.plugins.branchinator.model.BranchBuildStatus;
import com.atlassian.bamboo.plugins.branchinator.model.BranchSearchResult;
import com.atlassian.bamboo.plugins.branchinator.model.BuildsSortOrder;
import com.atlassian.bamboo.plugins.branchinator.model.RestBranchBuild;
import com.atlassian.bamboo.plugins.branchinator.model.RestRepository;
import com.atlassian.bamboo.rest.model.plan.RestPlanIdentifier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BranchinatorDtoComparators {
    private static Comparator<BranchBuildStatus> BUILD_STATUS_ORDER = Ordering.explicit((List)ImmutableList.of((Object)((Object)BranchBuildStatus.FAILED), (Object)((Object)BranchBuildStatus.SPECS_FAILURE), (Object)((Object)BranchBuildStatus.NOT_BUILT), (Object)((Object)BranchBuildStatus.BUILDING), (Object)((Object)BranchBuildStatus.SYNCING), (Object)((Object)BranchBuildStatus.QUEUED), (Object)((Object)BranchBuildStatus.SUCCESSFUL_PARTIAL), (Object)((Object)BranchBuildStatus.SPECS_SUCCESS), (Object)((Object)BranchBuildStatus.SUCCESSFUL), (Object)((Object)BranchBuildStatus.DISABLED), (Object)((Object)BranchBuildStatus.NO_HISTORY)));

    private BranchinatorDtoComparators() {
    }

    public static Comparator<RestBranchBuild> buildsForBranchSortOrder(@NotNull BuildsSortOrder sortOrder) {
        switch (sortOrder) {
            case BY_COMPLETION_DATE: {
                return BranchinatorDtoComparators.compareBuildByDateOfCompletion().thenComparing(BranchinatorDtoComparators.compareBuildByStatus()).thenComparing(BranchinatorDtoComparators.compareBuildByName());
            }
            case BY_PLAN_NAME: {
                return BranchinatorDtoComparators.compareBuildByName().thenComparing(BranchinatorDtoComparators.compareBuildByStatus()).thenComparing(BranchinatorDtoComparators.compareBuildByDateOfCompletion());
            }
            case BY_BUILD_STATUS: {
                return BranchinatorDtoComparators.compareBuildByStatus().thenComparing(BranchinatorDtoComparators.compareBuildByDateOfCompletion()).thenComparing(BranchinatorDtoComparators.compareBuildByName());
            }
        }
        throw new IllegalArgumentException("Unknown sort order: " + sortOrder.name());
    }

    public static Comparator<RestPlanIdentifier> availableBuildsForBranchSortOrder() {
        return Comparator.comparing(RestPlanIdentifier::getName, String.CASE_INSENSITIVE_ORDER);
    }

    public static Comparator<BranchSearchResult> branchesForSearchTermSortOrder() {
        return Comparator.comparing(BranchSearchResult::getBranchName);
    }

    public static Comparator<BranchSearchResult> branchesWithoutSearchTermSortOrder(@NotNull List<String> recentBranches) {
        return Comparator.comparing(BranchSearchResult::getBranchName, BranchinatorDtoComparators.compareListPosition(recentBranches)).thenComparing(BranchSearchResult::getBranchName);
    }

    public static Comparator<RestRepository> repositoriesForSearchTermSortOrder() {
        return Comparator.comparing(RestRepository::getName);
    }

    public static Comparator<RestRepository> repositoriesWithoutSearchTermSortOrder(@NotNull List<Long> recentRepoIds) {
        return Comparator.comparing(RestRepository::getId, BranchinatorDtoComparators.compareListPosition(recentRepoIds)).thenComparing(RestRepository::getName);
    }

    private static <T> Comparator<T> compareListPosition(@NotNull List<T> list) {
        return Comparator.comparingInt(e -> BranchinatorDtoComparators.listPositionForSorting(list, e));
    }

    private static <T> int listPositionForSorting(@NotNull List<T> list, @NotNull T element) {
        int index = list.indexOf(element);
        return index >= 0 ? index : Integer.MAX_VALUE;
    }

    private static Comparator<RestBranchBuild> compareBuildByStatus() {
        return Comparator.comparing(build -> build.getStatusIcon().getBranchBuildStatus(), BUILD_STATUS_ORDER);
    }

    private static Comparator<RestBranchBuild> compareBuildByDateOfCompletion() {
        return Comparator.comparingLong(RestBranchBuild::getLastBuildEpoch).reversed();
    }

    private static Comparator<RestBranchBuild> compareBuildByName() {
        return Comparator.comparing(RestBranchBuild::getProjectName).thenComparing(RestBranchBuild::getPlanName);
    }
}

