/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.service;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.chains.ChainExecutionAccessor;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.branchinator.model.BranchBuildStatus;
import com.atlassian.bamboo.plugins.branchinator.model.BuildsSortOrder;
import com.atlassian.bamboo.plugins.branchinator.model.RestBranchBuild;
import com.atlassian.bamboo.plugins.branchinator.model.RestBranchBuilds;
import com.atlassian.bamboo.plugins.branchinator.model.StatusIcon;
import com.atlassian.bamboo.plugins.branchinator.service.StatusIconBuilderFactory;
import com.atlassian.bamboo.plugins.branchinator.util.BranchinatorDtoComparators;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class RestBranchBuildsBuilderFactory {
    private final BambooPermissionManager bambooPermissionManager;
    private final ChainExecutionAccessor chainExecutionAccessor;
    private final PlanExecutionManager planExecutionManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final StatusIconBuilderFactory statusIconBuilderFactory;
    private final WebResourceUrlProvider webResourceUrlProvider;

    @Autowired
    public RestBranchBuildsBuilderFactory(@ComponentImport BambooPermissionManager bambooPermissionManager, @ComponentImport ChainExecutionAccessor chainExecutionAccessor, @ComponentImport PlanExecutionManager planExecutionManager, @ComponentImport ResultsSummaryManager resultsSummaryManager, StatusIconBuilderFactory statusIconBuilderFactory, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        this.bambooPermissionManager = bambooPermissionManager;
        this.chainExecutionAccessor = chainExecutionAccessor;
        this.planExecutionManager = planExecutionManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.statusIconBuilderFactory = statusIconBuilderFactory;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public Builder builder() {
        return new Builder();
    }

    public class Builder {
        private String branchName;
        private List<ImmutableChain> buildsForBranch;
        private String currentUserEmail;
        private BuildsSortOrder sortOrder;
        private String repositoryPluginKey;

        public Builder withBranchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public Builder withBuildsForBranch(List<ImmutableChain> buildsForBranch, BuildsSortOrder sortOrder) {
            this.buildsForBranch = buildsForBranch;
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder withCurrentUserEmail(String currentUserEmail) {
            this.currentUserEmail = currentUserEmail;
            return this;
        }

        public Builder withRepositoryPluginKey(String repositoryPluginKey) {
            this.repositoryPluginKey = repositoryPluginKey;
            return this;
        }

        public RestBranchBuilds build() {
            List<RestBranchBuild> restChainsForBranch = this.buildsForBranch.stream().map(this::chainToBranchBuild).sorted(BranchinatorDtoComparators.buildsForBranchSortOrder(this.sortOrder)).collect(Collectors.toList());
            return new RestBranchBuilds(this.branchName, restChainsForBranch, this.repositoryPluginKey);
        }

        private RestBranchBuild chainToBranchBuild(ImmutableChain branch) {
            Collection activeResults;
            RestBranchBuild.Builder builder = RestBranchBuild.builder();
            builder.planKey(branch.getPlanKey().getKey());
            builder.projectName(branch.getProject().getName());
            ImmutableChain master = branch.getMaster();
            if (master != null) {
                builder.planName(master.getBuildName());
                builder.branchName(branch.getBuildName());
            } else {
                builder.planName(branch.getBuildName());
            }
            builder.statusIcon(this.buildStatusIcon(branch));
            builder.numberOfCurrentlyBuildingPlans(this.getNumberOfCurrentlyBuildingPlans(branch));
            builder.hasBuildPermission(RestBranchBuildsBuilderFactory.this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.BUILD, (ImmutablePlan)branch));
            builder.hasEditPermission(RestBranchBuildsBuilderFactory.this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, (ImmutablePlan)branch));
            builder.hasPlanAdminPermission(RestBranchBuildsBuilderFactory.this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, (ImmutablePlan)branch));
            ImmutableResultsSummary latestResultsSummary = branch.getLatestResultsSummary();
            if (latestResultsSummary != null) {
                builder.buildNumber(latestResultsSummary.getBuildNumber());
                builder.buildState(latestResultsSummary.getBuildState().toString());
                builder.lastBuildTime(latestResultsSummary.getRelativeBuildDate());
                builder.reason(latestResultsSummary.getReasonSummary());
                builder.testResultsSummary(latestResultsSummary.getTestSummary());
                builder.nrCommits(latestResultsSummary.getCommits().size());
                builder.committerIsCurrentUser(this.committerIsCurrentUser(latestResultsSummary));
                if (latestResultsSummary.getBuildCompletedDate() != null) {
                    builder.lastBuildEpoch(latestResultsSummary.getBuildCompletedDate().getTime());
                }
            }
            if (!(activeResults = RestBranchBuildsBuilderFactory.this.resultsSummaryManager.getAllActiveResultSummariesForPlan(branch.getPlanKey(), ChainResultsSummary.class)).isEmpty()) {
                ChainResultsSummary latestActiveResult = (ChainResultsSummary)Comparators.getResultsSummaryNumberOrdering().greatestOf((Iterable)activeResults, 1).get(0);
                builder.latestActiveBuildNumber(latestActiveResult.getBuildNumber());
            }
            return builder.build();
        }

        private boolean committerIsCurrentUser(ImmutableResultsSummary latestResultsSummary) {
            return latestResultsSummary.getCommits().stream().anyMatch(this::committerIsCurrentUser);
        }

        private boolean committerIsCurrentUser(Commit commit) {
            Author author = commit.getAuthor();
            if (author == null) {
                return false;
            }
            String authorEmail = author.getEmail();
            return this.currentUserEmail.equals(authorEmail);
        }

        @NotNull
        private StatusIcon buildStatusIcon(ImmutableChain chain) {
            ChainResultsSummary latestSummary;
            String urlPrefix = RestBranchBuildsBuilderFactory.this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.ABSOLUTE);
            ImmutableResultsSummary buildSummary = chain.getLatestResultsSummary();
            BranchBuildStatus branchBuildStatus = chain.isSuspendedFromBuilding() ? BranchBuildStatus.DISABLED : (RestBranchBuildsBuilderFactory.this.chainExecutionAccessor.isActive(chain.getPlanKey()) ? (RestBranchBuildsBuilderFactory.this.chainExecutionAccessor.isExecuting(chain.getPlanKey()) ? BranchBuildStatus.BUILDING : BranchBuildStatus.QUEUED) : (RestBranchBuildsBuilderFactory.this.planExecutionManager.isBusy(chain.getPlanKey()) ? BranchBuildStatus.SYNCING : (buildSummary != null ? ((latestSummary = (ChainResultsSummary)Narrow.to((Object)buildSummary, ChainResultsSummary.class)) != null && latestSummary.isContinuable() ? BranchBuildStatus.SUCCESSFUL_PARTIAL : (buildSummary.isSuccessful() ? (ResultSummaryHelper.isBambooSpecSuccess((ImmutableResultsSummary)buildSummary) ? BranchBuildStatus.SPECS_SUCCESS : BranchBuildStatus.SUCCESSFUL) : (buildSummary.isFailed() ? (ResultSummaryHelper.isBambooSpecFailure((ImmutableResultsSummary)buildSummary) ? BranchBuildStatus.SPECS_FAILURE : BranchBuildStatus.FAILED) : (buildSummary.isNotBuilt() ? BranchBuildStatus.NOT_BUILT : BranchBuildStatus.NO_HISTORY)))) : BranchBuildStatus.NO_HISTORY)));
            return RestBranchBuildsBuilderFactory.this.statusIconBuilderFactory.builder().withBranchBuildStatus(branchBuildStatus).build();
        }

        private int getNumberOfCurrentlyBuildingPlans(ImmutableChain chain) {
            return RestBranchBuildsBuilderFactory.this.planExecutionManager.numberOfExecutions(chain.getPlanKey());
        }
    }
}

