/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.service;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.plugins.branchinator.ao.BranchSelectionStore;
import com.atlassian.bamboo.plugins.branchinator.service.RecentActivityService;
import com.atlassian.bamboo.plugins.branchinator.service.SelectedBranch;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecentActivityServiceImpl
implements RecentActivityService {
    private final BranchSelectionStore branchSelectionStore;
    private final RepositoryDefinitionManager repositoryDefinitionManager;

    @Autowired
    public RecentActivityServiceImpl(BranchSelectionStore branchSelectionStore, @ComponentImport RepositoryDefinitionManager repositoryDefinitionManager) {
        this.branchSelectionStore = branchSelectionStore;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    @Override
    @NotNull
    public List<SelectedBranch> getRecentlyVisitedBranches(@NotNull User user) {
        Map existingRepositories = this.repositoryDefinitionManager.getLinkedRepositories().stream().collect(Collectors.toMap(BambooIdProvider::getId, UnaryOperator.identity()));
        List<SelectedBranch> recentBranches = this.branchSelectionStore.getRecentBranches(user).stream().filter(recentBranch -> existingRepositories.containsKey(recentBranch.getSelectedRepoId())).collect(Collectors.toList());
        recentBranches.forEach(recentBranch -> recentBranch.setSelectedRepoName(((VcsRepositoryData)existingRepositories.get(recentBranch.getSelectedRepoId())).getName()));
        return recentBranches;
    }

    @Override
    @NotNull
    public List<String> getRecentlyVisitedBranchesForRepo(@NotNull User user, long repositoryId) {
        return this.getRecentlyVisitedBranches(user).stream().filter(recent -> recent.getSelectedRepoId() == repositoryId).map(SelectedBranch::getSelectedBranchName).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<Long> getIdsOfRecentlyVisitedRepositories(@NotNull User user) {
        return ImmutableList.copyOf((Collection)this.getRecentlyVisitedBranches(user).stream().map(SelectedBranch::getSelectedRepoId).collect(Collectors.toCollection(LinkedHashSet::new)));
    }
}

