/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.rest;

import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plugins.branchinator.model.RestUserProperty;
import com.atlassian.bamboo.plugins.branchinator.rest.RestHelperService;
import com.atlassian.bamboo.plugins.branchinator.service.UserPropertiesService;
import com.atlassian.bamboo.plugins.branchinator.service.UserPropertyKey;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class BranchinatorConfigResource {
    private final I18nResolver i18nResolver;
    private final RestHelperService restHelperService;
    private final UserPropertiesService userPropertiesService;

    @Autowired
    public BranchinatorConfigResource(@ComponentImport I18nResolver i18nResolver, RestHelperService restHelperService, UserPropertiesService userPropertiesService) {
        this.i18nResolver = i18nResolver;
        this.restHelperService = restHelperService;
        this.userPropertiesService = userPropertiesService;
    }

    @GET
    @Path(value="user/{propertyName}")
    public Response getUserProperty(@PathParam(value="propertyName") String propertyName) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            Optional<UserPropertyKey> propertyKey = UserPropertyKey.forKey(propertyName);
            BambooValidationUtils.validate((boolean)propertyKey.isPresent(), () -> this.i18nResolver.getText("branchinator.rest.error.unknown.user.property", new Serializable[]{propertyName}));
            return Response.ok().entity((Object)new RestUserProperty(propertyName, this.userPropertiesService.getUserProperty(propertyKey.get()))).build();
        }));
    }

    @PUT
    @Path(value="user/{propertyName}")
    public Response setUserProperty(@PathParam(value="propertyName") String propertyName, @NotNull RestUserProperty property) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            Optional<UserPropertyKey> propertyKey = UserPropertyKey.forKey(propertyName);
            BambooValidationUtils.validate((boolean)propertyKey.isPresent(), () -> this.i18nResolver.getText("branchinator.rest.error.unknown.user.property", new Serializable[]{propertyName}));
            this.userPropertiesService.setUserProperty(propertyKey.get(), property.getValue());
            return Response.ok().entity((Object)new RestUserProperty(propertyName, this.userPropertiesService.getUserProperty(propertyKey.get()))).build();
        }));
    }
}

