/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.rest;

import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.index.PlanRepositoryIndex;
import com.atlassian.bamboo.plugins.branchinator.ao.BranchSelectionStore;
import com.atlassian.bamboo.plugins.branchinator.model.BranchCommit;
import com.atlassian.bamboo.plugins.branchinator.model.BranchSearchResult;
import com.atlassian.bamboo.plugins.branchinator.model.BuildsSortOrder;
import com.atlassian.bamboo.plugins.branchinator.model.RestBranchBuilds;
import com.atlassian.bamboo.plugins.branchinator.model.RestRepository;
import com.atlassian.bamboo.plugins.branchinator.model.RestRepositoryType;
import com.atlassian.bamboo.plugins.branchinator.model.RestUnsupportedRepositoryTypeError;
import com.atlassian.bamboo.plugins.branchinator.rest.RestHelperService;
import com.atlassian.bamboo.plugins.branchinator.service.RecentActivityService;
import com.atlassian.bamboo.plugins.branchinator.service.RestBranchBuildsBuilderFactory;
import com.atlassian.bamboo.plugins.branchinator.util.BranchinatorDtoComparators;
import com.atlassian.bamboo.repository.RepositoryCachingFacade;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.rest.model.plan.RestPlanIdentifier;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.gravatar.GravatarService;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.utils.NameProvider;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class BranchBuildsResource {
    private static final Logger log = Logger.getLogger(BranchBuildsResource.class);
    private static final String PULL_REQUESTS_NOT_SUPPORTED = "pullRequestsNotSupported";
    private static final List<String> PULL_REQUEST_AWARE_REPOSITORIES = Collections.singletonList("com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver");
    private final BambooPermissionManager bambooPermissionManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final CachedPlanManager cachedPlanManager;
    private final GravatarService gravatarService;
    private final RepositoryCachingFacade repositoryCachingFacade;
    private final BambooAuthenticationContext bambooAuthenticationContext;
    private final BranchSelectionStore branchSelectionStore;
    private final CustomVariableContext customVariableContext;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final VcsRepositoryViewerManager vcsRepositoryViewerManager;
    private final RestBranchBuildsBuilderFactory restBranchBuildsBuilderFactory;
    private final RestHelperService restHelperService;
    private final I18nResolver i18nResolver;
    private final RecentActivityService recentActivityService;
    private final BambooUrl bambooUrl;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public BranchBuildsResource(@ComponentImport BambooPermissionManager bambooPermissionManager, @ComponentImport RepositoryDefinitionManager repositoryDefinitionManager, @ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport GravatarService gravatarService, @ComponentImport RepositoryCachingFacade repositoryCachingFacade, @ComponentImport BambooAuthenticationContext bambooAuthenticationContext, BranchSelectionStore branchSelectionStore, @ComponentImport VcsRepositoryManager vcsRepositoryManager, @ComponentImport VcsRepositoryViewerManager vcsRepositoryViewerManager, @ComponentImport CustomVariableContext customVariableContext, RestBranchBuildsBuilderFactory restBranchBuildsBuilderFactory, RestHelperService restHelperService, @ComponentImport I18nResolver i18nResolver, RecentActivityService recentActivityService, @ComponentImport AdministrationConfigurationAccessor administrationConfigurationAccessor, @ComponentImport TransactionTemplate transactionTemplate) {
        this.bambooPermissionManager = bambooPermissionManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.cachedPlanManager = cachedPlanManager;
        this.gravatarService = gravatarService;
        this.repositoryCachingFacade = repositoryCachingFacade;
        this.branchSelectionStore = branchSelectionStore;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
        this.customVariableContext = customVariableContext;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.vcsRepositoryViewerManager = vcsRepositoryViewerManager;
        this.restBranchBuildsBuilderFactory = restBranchBuildsBuilderFactory;
        this.restHelperService = restHelperService;
        this.i18nResolver = i18nResolver;
        this.recentActivityService = recentActivityService;
        this.bambooUrl = new BambooUrl(administrationConfigurationAccessor);
        this.transactionTemplate = transactionTemplate;
    }

    @GET
    @Path(value="branchesWithPlans")
    public Response getBranchesWithPlans(@QueryParam(value="searchTerm") String partialBranchName) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> this.getBranchesWithPlansForPartialBranchName(partialBranchName)));
    }

    @GET
    @Path(value="builds")
    public Response getBuildsForBranch(@QueryParam(value="repoId") long rootRepoId, @QueryParam(value="branchName") String branchName, @QueryParam(value="sortBy") String sortColumn) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            BambooValidationUtils.validate((boolean)StringUtils.isNotBlank((CharSequence)branchName), () -> this.i18nResolver.getText("branchinator.rest.error.branch.name.empty"));
            return (Response)this.transactionTemplate.execute(() -> {
                BuildsSortOrder sortOrder = StringUtils.isNotEmpty((CharSequence)sortColumn) ? BuildsSortOrder.forColumn(sortColumn) : BuildsSortOrder.DEFAULT;
                RepositoryDataEntity repositoryDataEntity = this.restHelperService.getLinkedRepositoryDataEntity(rootRepoId);
                this.restHelperService.verifyRepositoryPermission(repositoryDataEntity, BambooPermission.READ);
                this.branchSelectionStore.saveBranchSelection(this.bambooAuthenticationContext.getUser(), rootRepoId, branchName);
                PlanRepositoryIndex.Query query = new PlanRepositoryIndex.Query();
                query.rootRepoId = rootRepoId;
                query.branch = branchName;
                List<ImmutableChain> buildsForBranch = this.cachedPlanManager.getFilteredPlansWithRepository(query).filter(chain -> this.repositoryIsDefaultForChain(rootRepoId, (ImmutableChain)chain)).collect(Collectors.toList());
                RestBranchBuilds result = this.restBranchBuildsBuilderFactory.builder().withBranchName(branchName).withBuildsForBranch(buildsForBranch, sortOrder).withCurrentUserEmail(this.bambooAuthenticationContext.getUser().getEmail()).withRepositoryPluginKey(repositoryDataEntity.getPluginKey()).build();
                return Response.ok((Object)result).build();
            });
        }));
    }

    @GET
    @Path(value="branches")
    public Response getBranchesForRepo(@QueryParam(value="repoId") long rootRepoId, @QueryParam(value="searchTerm") String searchTerm) throws RepositoryException {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            VcsRepositoryData repoData = this.restHelperService.getLinkedRepositoryVcsData(rootRepoId);
            this.restHelperService.verifyRepositoryPermission(repoData, BambooPermission.READ);
            VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repoData.getPluginKey());
            BambooValidationUtils.validate((moduleDescriptor != null && moduleDescriptor.supportsBranchDetection() ? 1 : 0) != 0, () -> this.i18nResolver.getText("branchinator.rest.error.branches.not.supported", new Serializable[]{repoData.getName()}));
            try {
                VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext();
                List branches = (List)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> Lists.newArrayList((Iterable)this.repositoryCachingFacade.getOpenBranches(moduleDescriptor.getBranchDetector(), repoData)));
                boolean searchTermProvided = StringUtils.isNotEmpty((CharSequence)searchTerm);
                Predicate<BranchSearchResult> matchesSearchTerm = searchTermProvided ? result -> StringUtils.containsIgnoreCase((CharSequence)result.getBranchName(), (CharSequence)searchTerm) : result -> true;
                Comparator<BranchSearchResult> resultComparator = searchTermProvided ? BranchinatorDtoComparators.branchesForSearchTermSortOrder() : BranchinatorDtoComparators.branchesWithoutSearchTermSortOrder(this.recentActivityService.getRecentlyVisitedBranchesForRepo(this.bambooAuthenticationContext.getUser(), rootRepoId));
                List branchSearchResults = branches.stream().map(NameProvider::getName).map(branchName -> new BranchSearchResult(repoData.getRootVcsRepositoryId(), repoData.getName(), (String)branchName)).filter(matchesSearchTerm).sorted(resultComparator).collect(Collectors.toList());
                return Response.ok(branchSearchResults).build();
            }
            catch (Exception e) {
                throw new WebValidationException(this.i18nResolver.getText("branchinator.rest.error.branch.fetch.failed", new Serializable[]{repoData.getName()}));
            }
        }));
    }

    @GET
    @Path(value="repos")
    public Response getRepositories(@QueryParam(value="searchTerm") String searchTerm) throws RepositoryException {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            Comparator<RestRepository> resultComparator = StringUtils.isNotBlank((CharSequence)searchTerm) ? BranchinatorDtoComparators.repositoriesForSearchTermSortOrder() : BranchinatorDtoComparators.repositoriesWithoutSearchTermSortOrder(this.recentActivityService.getIdsOfRecentlyVisitedRepositories(this.bambooAuthenticationContext.getUser()));
            List reposResultList = this.repositoryDefinitionManager.getLinkedRepositories().stream().filter(repoData -> {
                VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repoData.getPluginKey());
                return moduleDescriptor != null && moduleDescriptor.supportsBranchDetection() && (StringUtils.isBlank((CharSequence)searchTerm) || StringUtils.containsIgnoreCase((CharSequence)repoData.getName(), (CharSequence)searchTerm));
            }).map(repoData -> new RestRepository(repoData.getId(), repoData.getName())).sorted(resultComparator).collect(Collectors.toList());
            return Response.ok(reposResultList).build();
        }));
    }

    @GET
    @Path(value="commits")
    public Response getCommitsIncludedInBuild(@QueryParam(value="planKey") String planKeyString) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            PlanKey planKey = PlanKeys.getPlanKey((String)planKeyString);
            ImmutableChain chain = this.restHelperService.getImmutableChain(planKey);
            this.restHelperService.verifyPlanPermission((ImmutablePlan)chain, BambooPermission.READ);
            return Response.ok(this.getLatestCommitsFromPlan((ImmutablePlan)chain)).build();
        }));
    }

    @GET
    @Path(value="builds/available")
    public Response getAvailablePlansForBranch(@QueryParam(value="repoId") long rootRepoId, @QueryParam(value="branchName") @Nullable String branchName, @QueryParam(value="searchTerm") @Nullable String searchTerm) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            BambooValidationUtils.validate((boolean)StringUtils.isNotEmpty((CharSequence)branchName), () -> this.i18nResolver.getText("branchinator.rest.error.branch.name.empty"));
            RepositoryDataEntity repositoryDataEntity = this.restHelperService.getLinkedRepositoryDataEntity(rootRepoId);
            this.restHelperService.verifyRepositoryPermission(repositoryDataEntity, BambooPermission.READ);
            List availableChains = this.repositoryDefinitionManager.getIdentifiersOfPlansUsingRepositoryOrItsDirectChildren(rootRepoId).stream().filter(planIdentifier -> planIdentifier.getPlanType() == PlanType.CHAIN).map(planIdentifier -> (ImmutableChain)this.cachedPlanManager.getPlanByKey(planIdentifier.getPlanKey(), ImmutableChain.class)).filter(chain -> this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, (ImmutablePlan)chain)).filter(chain -> this.repositoryIsDefaultForChain(rootRepoId, (ImmutableChain)chain)).filter(chain -> this.chainMatchesSearchTerm((PlanIdentifier)chain, searchTerm)).filter(chain -> !this.chainHasPlanBranch((PlanIdentifier)chain, branchName)).map(RestPlanIdentifier::new).sorted(BranchinatorDtoComparators.availableBuildsForBranchSortOrder()).collect(Collectors.toList());
            return Response.ok(availableChains).build();
        }));
    }

    @GET
    @Path(value="pullRequest")
    public Response getPullRequests(@QueryParam(value="repoId") long rootRepoId, @QueryParam(value="branchName") String branchName) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            String pluginKey;
            BambooValidationUtils.validate((boolean)StringUtils.isNotEmpty((CharSequence)branchName), () -> this.i18nResolver.getText("branchinator.rest.error.branch.name.empty"));
            RepositoryDataEntity repositoryDataEntity = this.restHelperService.getLinkedRepositoryDataEntity(rootRepoId);
            this.restHelperService.verifyRepositoryPermission(repositoryDataEntity, BambooPermission.READ);
            switch (pluginKey = repositoryDataEntity.getPluginKey()) {
                case "com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver": {
                    return Response.temporaryRedirect((URI)URI.create(this.bambooUrl.withBaseUrlFromRequest(BranchBuildsResource.getBbsPullRequestsUrl(rootRepoId, branchName)))).build();
                }
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.getPullRequestUnsupportedRestError()).build();
        }));
    }

    @GET
    @Path(value="pullRequest/canMerge")
    public Response canMergePullRequest(@QueryParam(value="repoId") long rootRepoId, @QueryParam(value="pullRequestId") long pullRequestId) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            String pluginKey;
            RepositoryDataEntity repositoryDataEntity = this.restHelperService.getLinkedRepositoryDataEntity(rootRepoId);
            this.restHelperService.verifyRepositoryPermission(repositoryDataEntity, BambooPermission.READ);
            switch (pluginKey = repositoryDataEntity.getPluginKey()) {
                case "com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver": {
                    return Response.temporaryRedirect((URI)URI.create(this.bambooUrl.withBaseUrlFromRequest(BranchBuildsResource.getBbsCanMergePullRequestUrl(rootRepoId, pullRequestId)))).build();
                }
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.getPullRequestUnsupportedRestError()).build();
        }));
    }

    @VisibleForTesting
    static String getBbsPullRequestsUrl(long rootRepoId, String branchName) {
        return UriBuilder.fromPath((String)"/rest/stash/latest/pullRequest").queryParam("repositoryId", new Object[]{rootRepoId}).queryParam("branch", new Object[]{EscapeChars.forUrl((String)branchName)}).queryParam("avatarSize", new Object[]{32}).build(new Object[0]).toString();
    }

    @VisibleForTesting
    static String getBbsCanMergePullRequestUrl(long rootRepoId, long pullRequestId) {
        return UriBuilder.fromPath((String)"/rest/stash/latest/pullRequest/{rootRepoId}/{pullRequestId}/canMerge").build(new Object[]{rootRepoId, pullRequestId}).toString();
    }

    private boolean chainMatchesSearchTerm(@NotNull PlanIdentifier chainIdentifier, @Nullable String searchTerm) {
        return StringUtils.isBlank((CharSequence)searchTerm) || StringUtils.containsIgnoreCase((CharSequence)chainIdentifier.getPlanKey().getKey(), (CharSequence)searchTerm) || StringUtils.containsIgnoreCase((CharSequence)chainIdentifier.getName(), (CharSequence)searchTerm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean chainHasPlanBranch(@NotNull PlanIdentifier chainIdentifier, @NotNull String branchName) {
        if (this.branchNameOfChainIdentifier(chainIdentifier).equals(branchName)) return true;
        if (!this.cachedPlanManager.getBranchesForChain(chainIdentifier).stream().map(this::branchNameOfChainOrBranch).anyMatch(branchName::equals)) return false;
        return true;
    }

    private boolean repositoryIsDefaultForChain(long rootRepoId, @NotNull ImmutableChain chain) {
        PlanRepositoryDefinition defaultRepo = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        return defaultRepo != null && defaultRepo.getRootVcsRepositoryId() == rootRepoId;
    }

    @NotNull
    private String branchNameOfChainIdentifier(@NotNull PlanIdentifier chainIdentifier) {
        Preconditions.checkState((chainIdentifier.getPlanType() == PlanType.CHAIN ? 1 : 0) != 0);
        try {
            PlanRepositoryDefinition defaultRepository = (PlanRepositoryDefinition)Iterables.getFirst((Iterable)this.repositoryDefinitionManager.getPlanRepositoryDefinitions(chainIdentifier), null);
            if (defaultRepository != null && defaultRepository.getBranch() != null) {
                return defaultRepository.getBranch().getVcsBranch().getName();
            }
        }
        catch (RuntimeException e) {
            log.debug((Object)"Repository fetching failed", (Throwable)e);
        }
        return "";
    }

    @NotNull
    private String branchNameOfChainOrBranch(@NotNull ImmutableChain chain) {
        try {
            PlanRepositoryDefinition defaultRepository = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
            if (defaultRepository != null && defaultRepository.getBranch() != null) {
                return defaultRepository.getBranch().getVcsBranch().getName();
            }
        }
        catch (RuntimeException e) {
            log.debug((Object)"Repository fetching failed", (Throwable)e);
        }
        return "";
    }

    private List<BranchCommit> getLatestCommitsFromPlan(ImmutablePlan plan) {
        ArrayList<BranchCommit> branchCommitList = new ArrayList<BranchCommit>();
        ImmutableResultsSummary latestResultsSummary = plan.getLatestResultsSummary();
        if (latestResultsSummary == null) {
            return branchCommitList;
        }
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(plan);
        this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> {
            for (RepositoryChangeset changeset : latestResultsSummary.getRepositoryChangesets()) {
                VcsRepositoryData repositoryData = this.repositoryDefinitionManager.getVcsRepositoryData(changeset.getRepositoryData().getId());
                VcsRepositoryViewer viewer = this.vcsRepositoryViewerManager.getViewerForRepository(repositoryData);
                changeset.getCommits().stream().map(c -> new BranchCommit((Commit)c, this.gravatarService, viewer != null ? viewer.getWebRepositoryUrlForRevision(c.getChangeSetId(), repositoryData) : null)).forEach(branchCommitList::add);
            }
        });
        return branchCommitList;
    }

    private static boolean smartContains(@NotNull String haystack, @NotNull String needle) {
        return BranchBuildsResource.isSingleCase(needle) ? StringUtils.containsIgnoreCase((CharSequence)haystack, (CharSequence)needle) : haystack.contains(needle);
    }

    private static boolean isSingleCase(@NotNull String str) {
        return StringUtils.isAllLowerCase((CharSequence)str) || StringUtils.isAllUpperCase((CharSequence)str);
    }

    private Response getBranchesWithPlansForPartialBranchName(String partialBranchName) throws WebValidationException {
        try {
            if (StringUtils.length((CharSequence)partialBranchName) < 2) {
                return Response.ok().build();
            }
            PlanRepositoryIndex.Query query = new PlanRepositoryIndex.Query();
            query.branchContains = partialBranchName;
            Stream<ImmutableChain> matchingPlans = this.cachedPlanManager.getFilteredPlansWithRepository(query).filter(chain -> Optional.ofNullable(PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain)).map(VcsRepositoryData::getBranch).map(branch -> BranchBuildsResource.smartContains(branch.getVcsBranch().getName(), partialBranchName)).orElse(false));
            Collection matchingRepoDefs = matchingPlans.map(PlanHelper::getDefaultPlanRepositoryDefinition).filter(VcsRepositoryData::isRootVcsLinked).collect(Collectors.toMap(e -> Pair.of((Object)e.getRootVcsRepositoryId(), (Object)e.getBranch().getVcsBranch().getName()), Function.identity(), (o, o2) -> o)).values();
            List branchSearchResults = matchingRepoDefs.stream().map(BranchSearchResult::new).sorted(BranchinatorDtoComparators.branchesForSearchTermSortOrder()).collect(Collectors.toList());
            return Response.ok(branchSearchResults).build();
        }
        catch (RuntimeException e2) {
            log.error((Object)"", (Throwable)e2);
            throw new WebValidationException(this.i18nResolver.getText("branchinator.rest.error.branch.fetch.failed", new Serializable[]{partialBranchName}));
        }
    }

    @NotNull
    private RestUnsupportedRepositoryTypeError getPullRequestUnsupportedRestError() {
        return new RestUnsupportedRepositoryTypeError(PULL_REQUESTS_NOT_SUPPORTED, this.vcsRepositoryManager.getAvailableRepositoryDescriptors().stream().filter(descriptor -> PULL_REQUEST_AWARE_REPOSITORIES.contains(descriptor.getCompleteKey())).map(RestRepositoryType::new).collect(Collectors.toList()));
    }
}

