/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.model;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.user.gravatar.GravatarService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="branchCommit")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BranchCommit {
    @XmlElement
    private String hash;
    @XmlElement
    private String authorEmail;
    @XmlElement
    private String authorGravatarUrl;
    @XmlElement
    private String authorName;
    @XmlElement
    private boolean committerIsCurrentUser;
    @XmlElement
    private String message;
    @XmlElement
    private String commitUrl;

    private BranchCommit() {
    }

    public BranchCommit(@NotNull Commit commit, @NotNull GravatarService gravatarService, @Nullable String commitUrl) {
        this.hash = commit.getChangeSetId();
        this.message = commit.getComment();
        this.commitUrl = commitUrl;
        Author author = commit.getAuthor();
        if (author != null) {
            String linkedUserName = author.getLinkedUserName();
            this.authorName = StringUtils.isBlank((CharSequence)linkedUserName) ? author.getName() : linkedUserName;
            this.authorEmail = commit.getAuthor().getEmail();
            this.authorGravatarUrl = gravatarService.getGravatarUrl(this.authorEmail);
        }
    }
}

