/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.model;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public enum BranchBuildStatus {
    DISABLED("disabled", "disabled"),
    BUILDING("building", "inProgress"),
    QUEUED("queued", "queued"),
    SYNCING("sync", "checkingOut"),
    SUCCESSFUL_PARTIAL("successfulpartial", "stopped"),
    SUCCESSFUL("successful", "success"),
    FAILED("failed", "failed"),
    SPECS_FAILURE("specsfailure", "specsFailure"),
    SPECS_SUCCESS("specssuccess", "specsSuccess"),
    NOT_BUILT("notbuilt", "notBuilt"),
    NO_HISTORY("disabled", "noHistory");

    public final String iconType;
    public final String statusCode;

    private BranchBuildStatus(String iconType, String statusCode) {
        this.iconType = iconType;
        this.statusCode = statusCode;
    }

    @NotNull
    public static BranchBuildStatus forIconType(@NotNull String iconType) {
        return Arrays.stream(BranchBuildStatus.values()).filter(status -> status.iconType.equals(iconType)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown icon type: " + iconType));
    }

    @NotNull
    public static BranchBuildStatus forStatusCode(@NotNull String statusCode) {
        return Arrays.stream(BranchBuildStatus.values()).filter(status -> status.statusCode.equals(statusCode)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown status code: " + statusCode));
    }
}

