/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.actions;

import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.branchinator.actions.DiscoveryDialogRedirectDestination;
import com.atlassian.bamboo.plugins.branchinator.navigation.KnownNavigationSource;
import com.atlassian.bamboo.plugins.branchinator.service.UserPropertiesService;
import com.atlassian.bamboo.plugins.branchinator.service.UserPropertyKey;
import com.atlassian.bamboo.plugins.branchinator.util.BranchinatorUrlBuilder;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.i18n.DocumentationLinkProvider;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.AuthenticatedUserSecurityAware;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class DiscoveryDialogRedirect
extends BambooActionSupport
implements AuthenticatedUserSecurityAware {
    private static final Logger log = Logger.getLogger(DiscoveryDialogRedirect.class);
    private static final String REDIRECT = "redirect";
    private final CachedPlanManager cachedPlanManager;
    private final DocumentationLinkProvider documentationLinkProvider;
    private final UserPropertiesService userPropertiesService;
    private final VcsRepositoryManager vcsRepositoryManager;
    private String planKey;
    private String destination;
    private String redirectUrl;

    @Autowired
    public DiscoveryDialogRedirect(@ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport DocumentationLinkProvider documentationLinkProvider, UserPropertiesService userPropertiesService, @ComponentImport VcsRepositoryManager vcsRepositoryManager) {
        this.cachedPlanManager = cachedPlanManager;
        this.documentationLinkProvider = documentationLinkProvider;
        this.userPropertiesService = userPropertiesService;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    public String execute() {
        if (RequestCacheThreadLocal.canRequestMutateState()) {
            this.userPropertiesService.setUserProperty(UserPropertyKey.DISCOVERY_DIALOG_DISPLAYED, "true");
        } else {
            log.debug((Object)"Non mutative request redirecting to Branch Status page, can't persist user properties");
        }
        DiscoveryDialogRedirectDestination redirectDestination = Optional.ofNullable(this.destination).map(DiscoveryDialogRedirectDestination::forDestinationName).orElse(null);
        if (redirectDestination == null) {
            this.redirectUrl = this.getBranchStatusBaseUrl();
        } else {
            switch (redirectDestination) {
                case BRANCH_STATUS_PAGE: {
                    this.redirectUrl = this.getBranchStatusUrlForPlan();
                    break;
                }
                case DOCUMENTATION: {
                    this.redirectUrl = this.getDocumentationUrl();
                }
            }
        }
        return REDIRECT;
    }

    private String getBranchStatusBaseUrl() {
        return new BranchinatorUrlBuilder().withSource(KnownNavigationSource.PLAN).build();
    }

    private String getBranchStatusUrlForPlan() {
        ImmutablePlan plan;
        if (StringUtils.isNotEmpty((CharSequence)this.planKey) && (plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)this.planKey))) != null) {
            return this.getBranchViewUrlForPlan(plan);
        }
        return this.getBranchStatusBaseUrl();
    }

    private String getDocumentationUrl() {
        return this.documentationLinkProvider.getUrl("branchinator.docs.using.branch.status.page");
    }

    @NotNull
    private String getBranchViewUrlForPlan(@NotNull ImmutablePlan plan) {
        PlanRepositoryDefinition repositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)plan);
        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = repositoryDefinition != null ? this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey()) : null;
        boolean repositoryIsSharedAndBranchable = repositoryDefinition != null && repositoryDefinition.isRootVcsLinked() && vcsRepositoryModuleDescriptor != null && vcsRepositoryModuleDescriptor.supportsBranchDetection();
        BranchinatorUrlBuilder urlBuilder = new BranchinatorUrlBuilder();
        urlBuilder.withSource(KnownNavigationSource.PLAN);
        if (repositoryIsSharedAndBranchable) {
            urlBuilder.withRepository(repositoryDefinition.getRootVcsRepositoryId(), repositoryDefinition.getName());
            if (repositoryDefinition.getBranch() != null) {
                urlBuilder.withBranch(repositoryDefinition.getBranch().getVcsBranch().getName());
            }
        }
        return urlBuilder.build();
    }

    public String getPlanKey() {
        return this.planKey;
    }

    public void setPlanKey(String planKey) {
        this.planKey = planKey;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }
}

