/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.export;

import com.atlassian.bamboo.plugins.variable.inject.VariableScope;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.InjectVariablesTask;
import com.atlassian.bamboo.specs.model.task.InjectVariablesScope;
import com.atlassian.bamboo.specs.model.task.InjectVariablesTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class InjectVariablesTaskExporter
implements TaskDefinitionExporter {
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Inject Variables");

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        InjectVariablesTaskProperties injectVariablesTaskProperties = (InjectVariablesTaskProperties)Narrow.downTo((Object)taskProperties, InjectVariablesTaskProperties.class);
        if (injectVariablesTaskProperties != null) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            cfg.put("filePath", injectVariablesTaskProperties.getPath());
            cfg.put("namespace", (String)ObjectUtils.firstNonNull((Object[])new String[]{injectVariablesTaskProperties.getNamespace(), InjectVariablesTaskProperties.DEFAULT_NAMESPACE}));
            cfg.put("scope", StringUtils.defaultString((String)injectVariablesTaskProperties.getScope().name(), (String)InjectVariablesScope.LOCAL.name()));
            return cfg;
        }
        throw new IllegalStateException("Don't know how to import task properties of type: " + taskProperties.getClass().getName());
    }

    @NotNull
    public InjectVariablesTask toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        InjectVariablesTask task = new InjectVariablesTask().path((String)configuration.get("filePath")).namespace(configuration.getOrDefault("namespace", InjectVariablesTaskProperties.DEFAULT_NAMESPACE));
        String scopeString = configuration.getOrDefault("scope", VariableScope.LOCAL.name());
        try {
            InjectVariablesScope scope = InjectVariablesScope.valueOf((String)scopeString);
            task.scope(scope);
            return task;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Unsupported inject variables task scope: " + scopeString);
        }
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        InjectVariablesTaskProperties properties = (InjectVariablesTaskProperties)Narrow.downTo((Object)taskProperties, InjectVariablesTaskProperties.class);
        if (properties == null) {
            return Collections.singletonList(new ValidationProblem(VALIDATION_CONTEXT, "Don't know how to import task properties of type: " + taskProperties.getClass().getName()));
        }
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        if (taskValidationContext.getOwnerDeployment().isPresent() && properties.getScope() != InjectVariablesScope.LOCAL) {
            problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("scope"), "Only LOCAL scope is supported for injected variables for deployment project"));
        }
        return problems;
    }
}

