/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.stash;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.bitbucket.BitbucketApplicationType;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.branches.MergeResultState;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.jira.rest.Errors;
import com.atlassian.bamboo.jira.rest.JiraRestResponse;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.AbstractNotificationRecipient;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plugin.descriptor.NotificationRecipientModuleDescriptor;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseTimeoutException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.struts.TextProvider;
import com.google.common.base.Supplier;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StashNotificationRecipient
extends AbstractNotificationRecipient
implements NotificationRecipient.RequiresResultSummary {
    private static final Logger log = Logger.getLogger(StashNotificationRecipient.class);
    private final String STASH_REST_URL_POINT = "rest/build-status/latest/commits/";
    private final String NOTIFICATION_BUILD_STATUS = "com/atlassian/bamboo/stash/notificationBuildStatus.ftl";
    private final String CONDITION_KEY = "conditionKey";
    private ResultsSummary resultsSummary;
    private TemplateRenderer templateRenderer;
    private TextProvider textProvider;
    private ErrorHandler errorHandler;
    private Supplier<ApplicationLinkService> applicationLinkService = ComponentAccessor.newLazyComponentReference((String)"applinkApplicationLink");
    private Supplier<TypeAccessor> typeAccessor = ComponentAccessor.newLazyComponentReference((String)"applinkTypeAccessor");
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    @NotNull
    public String getEditHtml() {
        String editTemplateLocation = ((NotificationRecipientModuleDescriptor)this.getModuleDescriptor()).getEditTemplate();
        return this.templateRenderer.render(editTemplateLocation, this.getRenderContextForConfig());
    }

    @NotNull
    public String getViewHtml() {
        String viewTemplateLocation = ((NotificationRecipientModuleDescriptor)this.getModuleDescriptor()).getViewTemplate();
        return this.templateRenderer.render(viewTemplateLocation, this.getRenderContextForConfig());
    }

    @NotNull
    public ErrorCollection validate(@NotNull Map<String, String[]> params) {
        String conditionKey;
        ErrorCollection errorCollection = super.validate(params);
        String string = conditionKey = params.containsKey("conditionKey") ? params.get("conditionKey")[0] : null;
        if (!"com.atlassian.bamboo.plugin.system.notifications:chainCompleted.allBuilds".equals(conditionKey)) {
            errorCollection.addError("conditionKey", this.textProvider.getText("bamboo.stash.plugin.invalid.event.type"));
        }
        return errorCollection;
    }

    @NotNull
    public List<NotificationTransport> getTransports() {
        ArrayList<NotificationTransport> list = new ArrayList<NotificationTransport>();
        list.add(new NotificationTransport(){

            public void sendNotification(@NotNull Notification notification) {
                JSONObject jsonData;
                String message = StringUtils.defaultString((String)StashNotificationRecipient.this.templateRenderer.render("com/atlassian/bamboo/stash/notificationBuildStatus.ftl", StashNotificationRecipient.this.getRenderContextForMessage()));
                PlanResultKey planResultKey = StashNotificationRecipient.this.resultsSummary.getPlanResultKey();
                try {
                    jsonData = new JSONObject().put("state", (Object)(StashNotificationRecipient.this.resultsSummary.isSuccessful() ? "SUCCESSFUL" : "FAILED")).put("key", (Object)planResultKey.getPlanKey()).put("name", (Object)StashNotificationRecipient.this.resultsSummary.getImmutablePlan().getName()).put("url", (Object)new BambooUrl(StashNotificationRecipient.this.administrationConfigurationAccessor).withBaseUrlFromConfiguration("/browse/" + planResultKey)).put("description", (Object)(message.length() > 255 ? message.substring(0, 255) : message));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                boolean hasSentAtLeastOneBuildStatus = false;
                for (ApplicationLink applicationLink : ((ApplicationLinkService)StashNotificationRecipient.this.applicationLinkService.get()).getApplicationLinks(((BitbucketApplicationType)((TypeAccessor)StashNotificationRecipient.this.typeAccessor.get()).getApplicationType(BitbucketApplicationType.class)).getClass())) {
                    MergeResultSummary mergeResult;
                    for (RepositoryChangeset repositoryChangeset : StashNotificationRecipient.this.resultsSummary.getRepositoryChangesets()) {
                        String changesetId = repositoryChangeset.getChangesetId();
                        hasSentAtLeastOneBuildStatus |= StashNotificationRecipient.this.sendStashNotification(planResultKey, jsonData, applicationLink, changesetId);
                    }
                    ChainResultsSummary chainResultsSummary = (ChainResultsSummary)Narrow.to((Object)StashNotificationRecipient.this.resultsSummary, ChainResultsSummary.class);
                    if (chainResultsSummary == null || (mergeResult = chainResultsSummary.getMergeResult()) == null || mergeResult.getPushState() != MergeResultState.SUCCESS) continue;
                    String mergeResultVcsKey = mergeResult.getMergeResultVcsKey();
                    hasSentAtLeastOneBuildStatus |= StashNotificationRecipient.this.sendStashNotification(planResultKey, jsonData, applicationLink, mergeResultVcsKey);
                }
                if (!hasSentAtLeastOneBuildStatus) {
                    StashNotificationRecipient.this.errorHandler.recordError((ResultKey)planResultKey, "No build status has been sent even though there is a Stash notification configured for that plan. Is your application link configured properly?", null);
                }
            }
        });
        return list;
    }

    private boolean sendStashNotification(PlanResultKey planResultKey, JSONObject jsonData, ApplicationLink applicationLink, String changesetId) {
        block5: {
            if (changesetId.length() != 40) {
                return false;
            }
            try {
                JiraRestResponse response = this.doRestCallViaApplink(applicationLink, "rest/build-status/latest/commits/" + changesetId, Request.MethodType.POST, jsonData);
                if (response.hasErrors() || response.statusCode != 204) {
                    log.error((Object)("Failed to store build status against Stash instance " + applicationLink.getName() + ", reason: " + response));
                    if (response.statusCode == 401) {
                        this.errorHandler.recordError((ResultKey)planResultKey, "\"401 Unauthorized\" received while attempting to store build status against Stash instance `" + applicationLink.getName() + "', check your application link configuration.", null);
                    }
                    break block5;
                }
                return true;
            }
            catch (CredentialsRequiredContextException e) {
                log.error((Object)("Credentials required while attempting to store build status against Stash instance " + applicationLink.getName()));
            }
        }
        return false;
    }

    public JiraRestResponse doRestCallViaApplink(@NotNull ApplicationLink applicationLink, @NotNull String requestUrl, @NotNull Request.MethodType methodType, @Nullable JSONObject data) throws CredentialsRequiredContextException {
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory(TwoLeggedOAuthAuthenticationProvider.class);
        if (requestFactory == null) {
            String errorMessage = "Failed to send stash build notification via " + applicationLink.getDisplayUrl() + " - it has to have OAuth authentication configured.";
            log.warn((Object)errorMessage);
            return new JiraRestResponse(errorMessage);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing JIRA request. " + methodType + " " + applicationLink.getDisplayUrl() + "/" + requestUrl));
            }
            ApplicationLinkRequest request = requestFactory.createRequest(methodType, requestUrl);
            request.setHeader("Content-Type", "application/json");
            if (methodType != Request.MethodType.GET && data != null) {
                request.setRequestBody(data.toString());
            }
            request.setSoTimeout((int)TimeUnit.SECONDS.toMillis(30L));
            JiraRestResponse response = (JiraRestResponse)request.executeAndReturn((ReturningResponseHandler)new JiraResponseHandler());
            if (response.hasErrors()) {
                log.warn((Object)("Failed to execute application link request. Server: " + applicationLink.getDisplayUrl() + " Method: " + methodType + " Url: " + requestUrl + "\n" + "Response: " + response.statusCode + " " + response.statusMessage + "\n" + "Errors: " + response.errors.toString()));
                if (log.isDebugEnabled() && StringUtils.isNotBlank((String)response.body)) {
                    log.debug((Object)("Response body: " + response.body));
                }
            }
            return response;
        }
        catch (ResponseTimeoutException e) {
            log.warn((Object)("Request to JIRA timed out. Server: " + applicationLink.getDisplayUrl() + " Method: " + methodType + " Url: " + requestUrl));
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new JiraRestResponse("Request to JIRA timed out: " + e.getMessage());
        }
        catch (ResponseException e) {
            log.warn((Object)("Failed to execute JIRA request. Server: " + applicationLink.getDisplayUrl() + " Method: " + methodType + " Url: " + requestUrl));
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new JiraRestResponse("Request to JIRA failed: " + e.getMessage());
        }
        catch (CredentialsRequiredException e) {
            log.info((Object)("Authentication was required, but credentials were not available when doing applink call. Server: " + applicationLink.getDisplayUrl() + " Method: " + methodType + " Url: " + requestUrl));
            throw new CredentialsRequiredContextException(applicationLink.getName(), e);
        }
    }

    private Map<String, Object> getRenderContextForMessage() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("resultsSummary", this.resultsSummary);
        context.put("buildSummary", this.resultsSummary);
        return context;
    }

    private Map<String, Object> getRenderContextForConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        boolean hasStashApplinkConfiguredProperly = false;
        for (ApplicationLink stashApplicationLink : ((ApplicationLinkService)this.applicationLinkService.get()).getApplicationLinks(((BitbucketApplicationType)((TypeAccessor)this.typeAccessor.get()).getApplicationType(BitbucketApplicationType.class)).getClass())) {
            ApplicationLinkRequestFactory requestFactory = stashApplicationLink.createAuthenticatedRequestFactory(TwoLeggedOAuthAuthenticationProvider.class);
            if (requestFactory == null) continue;
            hasStashApplinkConfiguredProperly = true;
            break;
        }
        if (!hasStashApplinkConfiguredProperly) {
            context.put("noStashApplinkConfigured", true);
        }
        return context;
    }

    public void setResultsSummary(@Nullable ResultsSummary resultsSummary) {
        this.resultsSummary = resultsSummary;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    static class JiraResponseHandler
    implements ReturningResponseHandler<Response, JiraRestResponse> {
        JiraResponseHandler() {
        }

        public JiraRestResponse handle(Response response) {
            JiraRestResponse.JiraRestResponseBuilder respBuilder = new JiraRestResponse.JiraRestResponseBuilder(response.getStatusCode(), response.getStatusText());
            if (!response.isSuccessful()) {
                try {
                    respBuilder.errors((Errors)response.getEntity(Errors.class));
                }
                catch (Exception entityException) {
                    try {
                        String responseString = IOUtils.toString((InputStream)response.getResponseBodyAsStream());
                        if (StringUtils.isNotBlank((String)responseString)) {
                            respBuilder.body(responseString);
                            respBuilder.addError("Request to JIRA failed. Returned with " + response.getStatusCode() + ". Response: " + responseString);
                        }
                    }
                    catch (Exception bodyException) {
                        respBuilder.addError("Request to JIRA failed. Returned with " + response.getStatusCode());
                    }
                }
            } else {
                try {
                    String responseString = IOUtils.toString((InputStream)response.getResponseBodyAsStream());
                    respBuilder.body(responseString);
                    if (StringUtils.isNotBlank((String)responseString)) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseString);
                            respBuilder.entity(jsonObject);
                        }
                        catch (JSONException e) {
                            respBuilder.addError("Failed to parse response: " + e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to extract body of JIRA's response", (Throwable)e);
                }
            }
            return respBuilder.build();
        }
    }
}

