/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.nodeunit;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser.MochaParserTaskType;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class NodeunitTaskType
implements TaskType {
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private final I18nResolver i18nResolver;
    private final TestCollationService testCollationService;

    public NodeunitTaskType(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, I18nResolver i18nResolver, TestCollationService testCollationService) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        this.i18nResolver = i18nResolver;
        this.testCollationService = testCollationService;
    }

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        try {
            ExternalProcess executeTestsProcess;
            BuildLogger buildLogger = taskContext.getBuildLogger();
            ConfigurationMap configurationMap = taskContext.getConfigurationMap();
            String nodeRuntime = (String)configurationMap.get((Object)"runtime");
            String nodePath = this.capabilityContext.getCapabilityValue("system.builder.node." + nodeRuntime);
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)nodePath), (Object)this.i18nResolver.getText("node.runtime.error.undefinedPath"));
            String nodeunitPath = (String)configurationMap.get((Object)"nodeunitRuntime");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)nodeunitPath), (Object)this.i18nResolver.getText("nodeunit.runtime.error.undefinedPath"));
            String testFiles = (String)configurationMap.get((Object)"testFiles");
            String testResultsDirectory = (String)configurationMap.get((Object)"testResultsDir");
            Map extraEnvironmentVariables = this.environmentVariableAccessor.splitEnvironmentAssignments((String)configurationMap.get((Object)"environmentVariables"), false);
            ImmutableList.Builder commandListBuilder = ImmutableList.builder().add((Object[])new String[]{nodePath, nodeunitPath});
            commandListBuilder.add((Object[])new String[]{"--reporter", "junit", "--output", testResultsDirectory});
            commandListBuilder.addAll((Iterable)CommandlineStringUtils.tokeniseCommandline((String)testFiles));
            String arguments = (String)configurationMap.get((Object)"arguments");
            if (StringUtils.isNotBlank((CharSequence)arguments)) {
                buildLogger.addBuildLogEntry("Using additional command line arguments: " + arguments);
                commandListBuilder.addAll((Iterable)CommandlineStringUtils.tokeniseCommandline((String)arguments));
            }
            if ((executeTestsProcess = this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().command((List)commandListBuilder.build()).env(extraEnvironmentVariables).path(FilenameUtils.getFullPath((String)nodePath)).workingDirectory(taskContext.getWorkingDirectory()))).getHandler().isComplete()) {
                TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(executeTestsProcess);
                boolean parseTestResults = configurationMap.getAsBoolean("parseTestResults");
                if (parseTestResults) {
                    String testFilePattern = MochaParserTaskType.calculateEffectiveFilePattern(taskContext, testResultsDirectory);
                    this.testCollationService.collateTestResults(taskContext, testFilePattern);
                    taskResultBuilder.checkTestFailures();
                }
                return taskResultBuilder.build();
            }
            throw new TaskException("Failed to execute command, external process not completed");
        }
        catch (Exception e) {
            throw new TaskException("Failed to execute task", (Throwable)e);
        }
    }
}

