/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.mocha.runner;

import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskExporter;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.MochaRunnerTask;
import com.atlassian.bamboo.specs.model.task.MochaRunnerTaskProperties;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class MochaRunnerTaskExporter
extends AbstractNodeRequiringTaskExporter<MochaRunnerTaskProperties, MochaRunnerTask> {
    @Autowired
    public MochaRunnerTaskExporter(UIConfigSupport uiConfigSupport) {
        super(MochaRunnerTaskProperties.class, uiConfigSupport);
    }

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return MochaRunnerTaskProperties.VALIDATION_CONTEXT;
    }

    @Override
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull MochaRunnerTaskProperties taskProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("mochaRuntime", taskProperties.getMochaExecutable());
        config.put("testFiles", taskProperties.getTestFilesAndDirectories());
        config.put("parseTestResults", Boolean.toString(taskProperties.isParseTestResults()));
        config.put("arguments", taskProperties.getArguments());
        return config;
    }

    @Override
    @NotNull
    protected MochaRunnerTask toSpecsEntity(@NotNull Map<String, String> taskConfiguration) {
        return new MochaRunnerTask().mochaExecutable(taskConfiguration.get("mochaRuntime")).testFilesAndDirectories(taskConfiguration.get("testFiles")).parseTestResults(Boolean.parseBoolean(taskConfiguration.getOrDefault("parseTestResults", Boolean.toString(MochaRunnerTask.DEFAULT_PARSE_TEST_RESULTS)))).arguments((String)taskConfiguration.getOrDefault("arguments", null));
    }

    @Override
    @NotNull
    public List<ValidationProblem> validate(@NotNull MochaRunnerTaskProperties taskProperties) {
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        if (StringUtils.isBlank((String)taskProperties.getMochaExecutable())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Mocha executable is not defined"));
        }
        if (StringUtils.isBlank((String)taskProperties.getTestFilesAndDirectories())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Test files and/or directories are not defined"));
        }
        return validationProblems;
    }
}

