/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.gulp;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GulpTaskType
implements CommonTaskType {
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private final I18nResolver i18nResolver;

    public GulpTaskType(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, I18nResolver i18nResolver) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        this.i18nResolver = i18nResolver;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        try {
            ConfigurationMap configurationMap = taskContext.getConfigurationMap();
            String nodeRuntime = (String)configurationMap.get((Object)"runtime");
            String nodePath = this.capabilityContext.getCapabilityValue("system.builder.node." + nodeRuntime);
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)nodePath), (Object)this.i18nResolver.getText("node.runtime.error.undefinedPath"));
            String gulpPath = (String)configurationMap.get((Object)"gulpRuntime");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)gulpPath), (Object)this.i18nResolver.getText("gulp.runtime.error.undefinedPath"));
            String task = (String)configurationMap.get((Object)"task");
            String configFile = (String)configurationMap.get((Object)"configFile");
            Map extraEnvironmentVariables = this.environmentVariableAccessor.splitEnvironmentAssignments((String)configurationMap.get((Object)"environmentVariables"), false);
            ImmutableList.Builder commandListBuilder = ImmutableList.builder().add((Object[])new String[]{nodePath, gulpPath});
            if (StringUtils.isNotBlank((CharSequence)configFile)) {
                commandListBuilder.add((Object[])new String[]{"--gulpfile", configFile});
            }
            commandListBuilder.addAll((Iterable)CommandlineStringUtils.tokeniseCommandline((String)task));
            taskResultBuilder.checkReturnCode(this.processService.executeExternalProcess(taskContext, new ExternalProcessBuilder().command((List)commandListBuilder.build()).env(extraEnvironmentVariables).path(FilenameUtils.getFullPath((String)nodePath)).workingDirectory(taskContext.getWorkingDirectory())));
            return taskResultBuilder.build();
        }
        catch (Exception e) {
            throw new TaskException("Failed to execute task", (Throwable)e);
        }
    }
}

