/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser.MochaSuite;
import com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser.MochaSuiteTest;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MochaReportCollector
implements TestReportCollector {
    private static final Logger log = Logger.getLogger(MochaReportCollector.class);

    @NotNull
    public TestCollectionResult collect(@NotNull File file) throws Exception {
        MochaSuite results;
        ArrayList<TestResults> pass = new ArrayList<TestResults>();
        ArrayList<TestResults> fail = new ArrayList<TestResults>();
        ArrayList<TestResults> skip = new ArrayList<TestResults>();
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").create();
        try (Iterator<MochaSuiteTest> fileReader = new BufferedReader(new FileReader(file));){
            results = (MochaSuite)gson.fromJson((Reader)((Object)fileReader), MochaSuite.class);
        }
        for (MochaSuiteTest test : results.getPasses()) {
            pass.add(MochaReportCollector.toTestResult(test, TestState.SUCCESS));
        }
        for (MochaSuiteTest test : results.getFailures()) {
            fail.add(MochaReportCollector.toTestResult(test, TestState.FAILED));
        }
        for (MochaSuiteTest test : results.getSkipped()) {
            skip.add(MochaReportCollector.toTestResult(test, TestState.SKIPPED));
        }
        TestCollectionResultBuilder builder = new TestCollectionResultBuilder();
        log.info((Object)results.toString());
        builder.addSuccessfulTestResults(pass);
        builder.addFailedTestResults(fail);
        builder.addSkippedTestResults(skip);
        return builder.build();
    }

    @NotNull
    public Set<String> getSupportedFileExtensions() {
        return Sets.newHashSet((Object[])new String[]{"json"});
    }

    private static TestResults toTestResult(@NotNull MochaSuiteTest test, @NotNull TestState state) {
        long durationInSeconds = TimeUnit.MILLISECONDS.toSeconds(test.getDuration());
        TestResults testResults = new TestResults(test.getFullTitle(), test.getTitle(), String.valueOf(durationInSeconds));
        testResults.setState(state);
        if (TestState.FAILED == state) {
            testResults.addError((TestCaseResultError)new TestCaseResultErrorImpl(test.getError()));
        }
        return testResults;
    }
}

