/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker;

import com.atlassian.bamboo.utils.Pair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryKey {
    private static final Logger log = Logger.getLogger(RepositoryKey.class);
    public static final String DEFAULT_TAG = "latest";
    private final String registry;
    private final String namespace;
    private final String repository;
    private final String tag;

    private RepositoryKey(@NotNull RepositoryKeyBuilder builder) {
        this.registry = builder.registry;
        this.namespace = builder.namespace;
        this.repository = builder.repository;
        this.tag = builder.tag;
    }

    @Nullable
    public String getRegistry() {
        return this.registry;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public String getRepository() {
        return this.repository;
    }

    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public String getEncodedRepositoryString() {
        return this.getRepositoryPart() + ':' + this.getEncodedTagPart();
    }

    @NotNull
    public Pair<String, String> getRepositoryTagParts() {
        return Pair.make((Object)this.getRepositoryPart(), (Object)this.getEncodedTagPart());
    }

    private String getRepositoryPart() {
        StringBuilder repositoryBuilder = new StringBuilder();
        if (this.registry != null) {
            repositoryBuilder.append(this.registry).append('/');
        }
        if (this.namespace != null) {
            repositoryBuilder.append(this.namespace).append('/');
        }
        repositoryBuilder.append(this.repository);
        return repositoryBuilder.toString();
    }

    @Nullable
    private String getEncodedTagPart() {
        try {
            return URIUtil.encodeQuery((String)this.tag);
        }
        catch (URIException e) {
            log.error((Object)String.format("Encoding of tag (%s) failed.", this.tag), (Throwable)e);
            return this.tag;
        }
    }

    static class RepositoryKeyBuilder {
        private String registry;
        private String namespace;
        private final String repository;
        private String tag = "latest";

        public RepositoryKeyBuilder(@NotNull String repository) {
            this.repository = repository;
        }

        @NotNull
        public RepositoryKeyBuilder registry(@Nullable String registry) {
            this.registry = registry;
            return this;
        }

        @NotNull
        public RepositoryKeyBuilder namespace(@Nullable String namespace) {
            this.namespace = namespace;
            return this;
        }

        @NotNull
        public RepositoryKeyBuilder tag(@NotNull String tag) {
            this.tag = tag;
            return this;
        }

        @NotNull
        public RepositoryKey build() {
            return new RepositoryKey(this);
        }
    }
}

