/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker;

import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.plugins.docker.CustomBuildDataHelper;
import com.atlassian.bamboo.plugins.docker.client.DockerCmd;
import com.atlassian.bamboo.plugins.docker.process.DefaultDockerProcessService;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DockerContainerCleanupProcessor
implements CustomBuildProcessor {
    private static final Logger log = Logger.getLogger(DockerContainerCleanupProcessor.class);
    private BuildContext buildContext;
    private CapabilityContext capabilityContext;

    public void init(@NotNull BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    @NotNull
    public BuildContext call() throws Exception {
        String dockerPath = this.capabilityContext.getCapabilityValue("system.docker.executable");
        DockerCmd docker = new DockerCmd(dockerPath, DefaultDockerProcessService.builder().build());
        Iterable<String> detachedContainers = CustomBuildDataHelper.getDetachedContainers(this.buildContext.getVariableContext());
        for (String detachedContainer : detachedContainers) {
            log.debug((Object)("Removing container: " + detachedContainer));
            docker.remove(detachedContainer);
        }
        return this.buildContext;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }
}

