/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.tasks;

import com.atlassian.bamboo.task.TaskDefinition;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerTaskPredicates {
    private DockerTaskPredicates() {
    }

    public static Predicate<TaskDefinition> isConfigurationFieldEqual(@NotNull String key, @NotNull String value) {
        return new IsConfigurationFieldEqualPredicate(key, value);
    }

    public static Predicate<TaskDefinition> isConfigurationFieldEqual(@NotNull String key, boolean value) {
        return new IsConfigurationFieldEqualPredicate(key, Boolean.toString(value));
    }

    private static class IsConfigurationFieldEqualPredicate
    implements Predicate<TaskDefinition> {
        private final String key;
        private final String value;

        private IsConfigurationFieldEqualPredicate(@NotNull String key, @NotNull String value) {
            this.key = key;
            this.value = value;
        }

        public boolean apply(@Nullable TaskDefinition input) {
            Map taskConfig = ((TaskDefinition)Preconditions.checkNotNull((Object)input)).getConfiguration();
            return taskConfig.containsKey(this.key) && ((String)taskConfig.get(this.key)).equals(this.value);
        }
    }
}

