/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.service;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.docker.DockerException;
import com.atlassian.bamboo.docker.PortMapping;
import com.atlassian.bamboo.docker.RunConfig;
import com.atlassian.bamboo.plugins.docker.CustomBuildDataHelper;
import com.atlassian.bamboo.plugins.docker.PollingService;
import com.atlassian.bamboo.plugins.docker.client.Docker;
import com.atlassian.bamboo.plugins.docker.config.RunConfiguration;
import com.atlassian.bamboo.plugins.docker.service.DockerService;
import com.atlassian.bamboo.plugins.docker.utils.DockerEnvironmentVariablesHelper;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.variable.VariableContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunService
implements DockerService {
    private static final Logger log = Logger.getLogger(RunService.class);
    private final Docker docker;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final PollingService pollingService;

    public RunService(@NotNull Docker docker, @NotNull EnvironmentVariableAccessor environmentVariableAccessor, @NotNull PollingService pollingService) {
        this.docker = docker;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.pollingService = pollingService;
    }

    @Override
    public void execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        BuildLogger logger = taskContext.getBuildLogger();
        Map customData = taskContext.getCommonContext().getCurrentResult().getCustomBuildData();
        VariableContext variableContext = taskContext.getCommonContext().getVariableContext();
        RunConfiguration runConfiguration = RunConfiguration.fromContext(taskContext);
        try {
            RunConfig runConfig = this.buildRunConfig(runConfiguration, variableContext);
            if (runConfiguration.isRunDetached()) {
                log.debug((Object)("Registering container: " + runConfiguration.getName()));
                CustomBuildDataHelper.registerContainer(variableContext, runConfiguration.getName());
            }
            logger.addBuildLogEntry(String.format("Running image name (%s)", runConfiguration.getImage()));
            this.docker.run(runConfiguration.getImage(), runConfig);
            if (runConfiguration.isWaitForService()) {
                String serviceUrl = this.getServiceUrl(runConfiguration);
                this.pollingService.waitUntilAvailable(serviceUrl, runConfiguration.getServiceTimeout(), logger);
                CustomBuildDataHelper.setDeployedServiceUrl(customData, serviceUrl);
            }
        }
        catch (Exception e) {
            throw new TaskException("Failed to execute task", (Throwable)e);
        }
    }

    @NotNull
    private RunConfig buildRunConfig(@NotNull RunConfiguration config, @NotNull VariableContext variableContext) throws DockerException {
        Map<String, String> links = this.getLinks(config, variableContext);
        Pair<Map<String, String>, List<String>> extraEnvironmentVariables = DockerEnvironmentVariablesHelper.splitEnvironmentVariables(this.environmentVariableAccessor, config.getEnvironmentVariables());
        RunConfig.Builder runConfig = RunConfig.builder().ports(config.getPorts()).volumes(config.getVolumes()).detach(config.isRunDetached()).links(links).env((Map)extraEnvironmentVariables.first).passedEnv((List)extraEnvironmentVariables.second);
        if (StringUtils.isNotBlank((CharSequence)config.getName())) {
            runConfig.containerName(config.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)config.getCommand())) {
            runConfig.command(config.getCommand());
        }
        if (StringUtils.isNotBlank((CharSequence)config.getWorkDir())) {
            runConfig.workDir(config.getWorkDir());
        }
        if (StringUtils.isNotBlank((CharSequence)config.getAdditionalArgs())) {
            runConfig.additionalArgs(config.getAdditionalArgs());
        }
        return runConfig.build();
    }

    @NotNull
    private Map<String, String> getLinks(@NotNull RunConfiguration taskConfig, @NotNull VariableContext variableContext) throws DockerException {
        HashMap<String, String> links = new HashMap<String, String>();
        if (taskConfig.isLink()) {
            Iterable<String> detachedContainers = CustomBuildDataHelper.getDetachedContainers(variableContext);
            for (String detachedContainerName : detachedContainers) {
                if (!this.docker.isRunning(detachedContainerName)) continue;
                links.put(detachedContainerName, detachedContainerName);
            }
        }
        return links;
    }

    @Nullable
    private String getServiceUrl(@NotNull RunConfiguration runConfig) throws DockerException {
        String serviceUrlPattern = runConfig.getServiceUrl();
        PortMapping firstPortMapping = runConfig.getFirstPort();
        if (StringUtils.isBlank((CharSequence)serviceUrlPattern) || firstPortMapping == null) {
            return serviceUrlPattern;
        }
        Integer hostPortFromConfiguration = firstPortMapping.getHostPort();
        Integer hostPort = hostPortFromConfiguration != null ? hostPortFromConfiguration : this.docker.getHostPort(runConfig.getName(), firstPortMapping.getContainerPort());
        return StringUtils.replace((String)serviceUrlPattern, (String)"${docker.port}", (String)String.valueOf(hostPort));
    }
}

