/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.service;

import com.atlassian.bamboo.plugins.docker.PollingService;
import com.atlassian.bamboo.plugins.docker.client.Docker;
import com.atlassian.bamboo.plugins.docker.export.BuildImageTaskExporter;
import com.atlassian.bamboo.plugins.docker.export.RegistryTaskExporter;
import com.atlassian.bamboo.plugins.docker.export.RunContainerTaskExporter;
import com.atlassian.bamboo.plugins.docker.service.BuildService;
import com.atlassian.bamboo.plugins.docker.service.DockerService;
import com.atlassian.bamboo.plugins.docker.service.DockerServiceFactory;
import com.atlassian.bamboo.plugins.docker.service.PullService;
import com.atlassian.bamboo.plugins.docker.service.PushService;
import com.atlassian.bamboo.plugins.docker.service.RunService;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.model.task.docker.DockerBuildImageTaskProperties;
import com.atlassian.bamboo.specs.model.task.docker.DockerRegistryTaskProperties;
import com.atlassian.bamboo.specs.model.task.docker.DockerRunContainerTaskProperties;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={DockerServiceFactory.class})
@Component(value="serviceFactory")
public class DockerServiceFactoryImpl
implements DockerServiceFactory {
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final PollingService pollingService;
    private final BuildImageTaskExporter buildImageTaskExporter;
    private final RegistryTaskExporter registryTaskExporter;
    private final RunContainerTaskExporter runContainerTaskExporter;

    @Autowired
    public DockerServiceFactoryImpl(@ComponentImport EnvironmentVariableAccessor environmentVariableAccessor, PollingService pollingService, BuildImageTaskExporter buildImageTaskExporter, RegistryTaskExporter registryTaskExporter, RunContainerTaskExporter runContainerTaskExporter) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.pollingService = pollingService;
        this.buildImageTaskExporter = buildImageTaskExporter;
        this.registryTaskExporter = registryTaskExporter;
        this.runContainerTaskExporter = runContainerTaskExporter;
    }

    @Override
    @NotNull
    public DockerService create(@NotNull Docker docker, @NotNull String dockerCommandOption) {
        if ("build".equals(dockerCommandOption)) {
            return new BuildService(docker);
        }
        if ("run".equals(dockerCommandOption)) {
            return new RunService(docker, this.environmentVariableAccessor, this.pollingService);
        }
        if ("push".equals(dockerCommandOption)) {
            return new PushService(docker);
        }
        if ("pull".equals(dockerCommandOption)) {
            return new PullService(docker);
        }
        throw new IllegalArgumentException("No service for option " + dockerCommandOption);
    }

    @Override
    @NotNull
    public TaskDefinitionExporter createExporter(@NotNull String dockerCommandOption) {
        if ("build".equals(dockerCommandOption)) {
            return this.buildImageTaskExporter;
        }
        if ("run".equals(dockerCommandOption)) {
            return this.runContainerTaskExporter;
        }
        if ("push".equals(dockerCommandOption)) {
            return this.registryTaskExporter;
        }
        if ("pull".equals(dockerCommandOption)) {
            return this.registryTaskExporter;
        }
        throw new IllegalArgumentException("No exporter for option " + dockerCommandOption);
    }

    @Override
    @NotNull
    public TaskDefinitionExporter createExporter(@NotNull TaskProperties taskProperties) {
        if (Narrow.downTo((Object)taskProperties, DockerBuildImageTaskProperties.class) != null) {
            return this.buildImageTaskExporter;
        }
        if (Narrow.downTo((Object)taskProperties, DockerRunContainerTaskProperties.class) != null) {
            return this.runContainerTaskExporter;
        }
        if (Narrow.downTo((Object)taskProperties, DockerRegistryTaskProperties.class) != null) {
            return this.registryTaskExporter;
        }
        throw new IllegalArgumentException("Can't export properties: " + taskProperties.getClass());
    }
}

