/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.process;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.plugins.docker.process.DefaultDockerProcessService;
import com.atlassian.bamboo.plugins.docker.process.DockerProcessService;
import com.atlassian.bamboo.plugins.docker.process.ProcessCommand;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.utils.process.ProcessException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DockerTaskProcessService
implements DockerProcessService {
    private final CommonTaskContext taskContext;
    private final TaskResultBuilder taskResultBuilder;
    private final ProcessService processService;
    private final ImmutableMap<String, String> environmentVariables;
    private final DockerProcessService defaultProcessService;

    private DockerTaskProcessService(@NotNull Builder builder) {
        this.taskContext = builder.taskContext;
        this.taskResultBuilder = builder.taskResultBuilder;
        this.processService = builder.processService;
        this.environmentVariables = ImmutableMap.copyOf((Map)builder.environmentVariables);
        this.defaultProcessService = DefaultDockerProcessService.builder().environmentVariables(builder.environmentVariables).workingDir(this.taskContext.getWorkingDirectory()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String execute(@NotNull ProcessCommand command) throws ProcessException {
        BuildLogInterceptor interceptor = new BuildLogInterceptor();
        try {
            this.taskContext.getBuildLogger().getInterceptorStack().add((LogInterceptor)interceptor);
            ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder().command(command.getCommandList()).workingDirectory(this.taskContext.getWorkingDirectory()).input(command.getInput());
            externalProcessBuilder.env(this.environmentVariables);
            this.taskResultBuilder.checkReturnCode(this.processService.executeExternalProcess(this.taskContext, externalProcessBuilder));
            if (this.taskResultBuilder.getTaskState() != TaskState.SUCCESS) {
                throw new ProcessException("Error executing " + PasswordMaskingUtils.maskPossiblePasswordValues((String)command.getSafeCommandString(), (VariableContext)this.taskContext.getCommonContext().getVariableContext()));
            }
        }
        finally {
            this.taskContext.getBuildLogger().getInterceptorStack().remove((LogInterceptor)interceptor);
        }
        return interceptor.getOutput();
    }

    @Override
    @NotNull
    public String executeSilently(@NotNull ProcessCommand command) throws ProcessException {
        return this.defaultProcessService.executeSilently(command);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.taskContext.getWorkingDirectory() != null ? this.taskContext.getWorkingDirectory().toPath() : null;
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public static Builder builder(@NotNull CommonTaskContext taskContext, @NotNull TaskResultBuilder taskResultBuilder, @NotNull ProcessService processService) {
        return new Builder(taskContext, taskResultBuilder, processService);
    }

    private class BuildLogInterceptor
    implements LogInterceptor {
        private final List<String> output = new ArrayList<String>();

        private BuildLogInterceptor() {
        }

        public void intercept(@NotNull LogEntry logEntry) {
            this.output.add(logEntry.getLog());
        }

        public void interceptError(@NotNull LogEntry logEntry) {
        }

        @NotNull
        public String getOutput() {
            return (String)Iterables.getLast(this.output);
        }
    }

    public static class Builder {
        private final CommonTaskContext taskContext;
        private final TaskResultBuilder taskResultBuilder;
        private final ProcessService processService;
        private Map<String, String> environmentVariables = Collections.emptyMap();

        private Builder(@NotNull CommonTaskContext taskContext, @NotNull TaskResultBuilder taskResultBuilder, @NotNull ProcessService processService) {
            this.taskContext = taskContext;
            this.taskResultBuilder = taskResultBuilder;
            this.processService = processService;
        }

        public Builder environmentVariables(@NotNull Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        @NotNull
        public DockerTaskProcessService build() {
            return new DockerTaskProcessService(this);
        }
    }
}

