/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.export;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.plugins.docker.tasks.cli.DockerCliTaskConfigurator;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.AbstractDockerRegistryTask;
import com.atlassian.bamboo.specs.builders.task.DockerPullImageTask;
import com.atlassian.bamboo.specs.builders.task.DockerPushImageTask;
import com.atlassian.bamboo.specs.model.task.docker.AbstractDockerTaskProperties;
import com.atlassian.bamboo.specs.model.task.docker.DockerRegistryTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class RegistryTaskExporter
implements TaskDefinitionExporter {
    private static final Set<String> ACCEPTABLE_COMMAND_OPTIONS = ImmutableSet.of((Object)"pull", (Object)"push");
    private CredentialsAccessor credentialsAccessor;

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        DockerRegistryTaskProperties properties = (DockerRegistryTaskProperties)Narrow.downTo((Object)taskProperties, DockerRegistryTaskProperties.class);
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)("Don't now how to import " + taskProperties.getClass().getCanonicalName()));
        ImmutableMap.Builder config = ImmutableMap.builder();
        switch (properties.getRegistryType()) {
            case DOCKER_HUB: {
                config.put((Object)"registryOption", (Object)"hub");
                break;
            }
            case CUSTOM: {
                config.put((Object)"registryOption", (Object)"custom");
                break;
            }
            default: {
                throw new IllegalStateException("Couldn't import: " + taskProperties);
            }
        }
        switch (properties.getOperationType()) {
            case PUSH: {
                config.put((Object)"commandOption", (Object)"push");
                config.put((Object)"email", (Object)StringUtils.defaultString((String)properties.getEmail()));
                config.put((Object)"username", (Object)StringUtils.defaultString((String)properties.getUsername()));
                config.put((Object)"password", (Object)StringUtils.defaultString((String)properties.getPassword()));
                config.put((Object)"pushSharedCredentialsId", (Object)this.getSharedCredentialsId(properties));
                config.put((Object)"pushRepository", (Object)StringUtils.defaultString((String)properties.getImage()));
                break;
            }
            case PULL: {
                config.put((Object)"commandOption", (Object)"pull");
                config.put((Object)"pullEmail", (Object)StringUtils.defaultString((String)properties.getEmail()));
                config.put((Object)"pullUsername", (Object)StringUtils.defaultString((String)properties.getUsername()));
                config.put((Object)"pullPassword", (Object)StringUtils.defaultString((String)properties.getPassword()));
                config.put((Object)"pullSharedCredentialsId", (Object)this.getSharedCredentialsId(properties));
                config.put((Object)"pullRepository", (Object)StringUtils.defaultString((String)properties.getImage()));
                break;
            }
            default: {
                throw new IllegalStateException("Couldn't handle operation type: " + properties.getOperationType());
            }
        }
        config.put((Object)"environmentVariables", (Object)StringUtils.defaultString((String)properties.getEnvironmentVariables()));
        config.put((Object)"workingSubDirectory", (Object)StringUtils.defaultString((String)properties.getWorkingSubdirectory()));
        return config.build();
    }

    @NotNull
    public Task toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        if (this.isDockerRegistryTask(taskDefinition)) {
            Map config = taskDefinition.getConfiguration();
            switch (config.getOrDefault("commandOption", "")) {
                case "push": {
                    DockerPushImageTask pushTask = (DockerPushImageTask)((DockerPushImageTask)new DockerPushImageTask().environmentVariables(config.getOrDefault("environmentVariables", ""))).workingSubdirectory(config.getOrDefault("workingSubDirectory", ""));
                    this.setAuthorization(taskDefinition, config, (AbstractDockerRegistryTask)pushTask, "pushSharedCredentialsId", "username", "password", "email");
                    return this.setDockerImage((AbstractDockerRegistryTask)pushTask, config.getOrDefault("registryOption", ""), config.getOrDefault("pushRepository", ""));
                }
                case "pull": {
                    DockerPullImageTask pullTask = (DockerPullImageTask)((DockerPullImageTask)new DockerPullImageTask().dockerHubImage(config.getOrDefault("pullRepository", "")).environmentVariables(config.getOrDefault("environmentVariables", ""))).workingSubdirectory(config.getOrDefault("workingSubDirectory", ""));
                    this.setAuthorization(taskDefinition, config, (AbstractDockerRegistryTask)pullTask, "pullSharedCredentialsId", "pullUsername", "pullPassword", "pullEmail");
                    return this.setDockerImage((AbstractDockerRegistryTask)pullTask, config.getOrDefault("registryOption", ""), config.getOrDefault("pullRepository", ""));
                }
            }
            throw new IllegalStateException("Something went badly. Couldn't export.");
        }
        throw new IllegalArgumentException(String.format("Couldn't export task by id: %s and plugin key: %s", taskDefinition.getId(), taskDefinition.getPluginKey()));
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        DockerRegistryTaskProperties properties = (DockerRegistryTaskProperties)Narrow.downTo((Object)taskProperties, DockerRegistryTaskProperties.class);
        if (properties == null) {
            return Collections.singletonList(new ValidationProblem("Don't now how to import " + taskProperties.getClass().getCanonicalName()));
        }
        if (properties.getSharedCredentialsIdentifier() != null) {
            String sharedCredentialsName = properties.getSharedCredentialsIdentifier().getName();
            CredentialsData credentials = this.credentialsAccessor.getCredentialsByName(sharedCredentialsName);
            ValidationContext sharedCredentialsContext = ValidationContext.of((String)"Docker task").with("Shared credentials");
            if (credentials == null) {
                return Collections.singletonList(new ValidationProblem(sharedCredentialsContext, "Can't find shared credentials with name '" + sharedCredentialsName + "'"));
            }
            if (!"com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials".equals(credentials.getPluginKey())) {
                return Collections.singletonList(new ValidationProblem(sharedCredentialsContext, "Shared credentials '" + credentials.getName() + "' should be Username/password type"));
            }
        }
        return Collections.emptyList();
    }

    @Inject
    public void setCredentialsAccessor(@ComponentImport CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    private String getSharedCredentialsId(DockerRegistryTaskProperties properties) {
        SharedCredentialsIdentifierProperties sharedCredentials = properties.getSharedCredentialsIdentifier();
        if (sharedCredentials == null) {
            return "";
        }
        CredentialsData credentials = this.credentialsAccessor.getCredentialsByName(sharedCredentials.getName());
        if (credentials == null) {
            return "";
        }
        return String.valueOf(credentials.getId());
    }

    private void setAuthorization(@NotNull TaskDefinition taskDefinition, Map<String, String> config, AbstractDockerRegistryTask registryTask, String sharedCredentialsIdKey, String usernameKey, String passwordKey, String emailKey) {
        if (DockerCliTaskConfigurator.isSharedCredentialsSourceActive(sharedCredentialsIdKey, taskDefinition.getConfiguration())) {
            long sharedCredentialsId = Long.parseLong(taskDefinition.getConfiguration().getOrDefault(sharedCredentialsIdKey, "-1"));
            CredentialsData credentials = this.credentialsAccessor.getCredentials(sharedCredentialsId);
            if (credentials != null) {
                registryTask.authentication(new SharedCredentialsIdentifier(credentials.getName()));
            }
        } else {
            registryTask.authentication(config.getOrDefault(usernameKey, ""), config.getOrDefault(passwordKey, ""), config.getOrDefault(emailKey, ""));
        }
    }

    @NotNull
    private Task setDockerImage(AbstractDockerRegistryTask task, String registryOption, String registry) {
        switch (registryOption) {
            case "hub": {
                return task.dockerHubImage(registry);
            }
            case "custom": {
                return task.customRegistryImage(registry);
            }
        }
        throw new IllegalStateException("Something went badly. Couldn't export.");
    }

    private boolean isDockerRegistryTask(@NotNull TaskDefinition taskDefinition) {
        return taskDefinition.getPluginKey().equals(AbstractDockerTaskProperties.MODULE_KEY.getCompleteModuleKey()) && ACCEPTABLE_COMMAND_OPTIONS.contains(taskDefinition.getConfiguration().get("commandOption"));
    }
}

