/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker;

import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.docker.DockerContainerService;
import com.atlassian.bamboo.plugins.docker.CustomBuildDataHelper;
import com.atlassian.bamboo.plugins.docker.client.DockerCmd;
import com.atlassian.bamboo.plugins.docker.process.DefaultDockerProcessService;
import com.atlassian.bamboo.process.ProcessContextFactory;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class DockerContainerCleanupProcessor
implements CustomBuildProcessor {
    private static final Logger log = Logger.getLogger(DockerContainerCleanupProcessor.class);
    private final DockerContainerService dockerContainerService;
    private BuildContext buildContext;
    private final CapabilityContext capabilityContext;
    private final ProcessContextFactory processContextFactory;

    @Autowired
    public DockerContainerCleanupProcessor(@ComponentImport DockerContainerService dockerContainerService, @ComponentImport CapabilityContext capabilityContext, @ComponentImport ProcessContextFactory processContextFactory) {
        this.dockerContainerService = dockerContainerService;
        this.capabilityContext = capabilityContext;
        this.processContextFactory = processContextFactory;
    }

    public void init(@NotNull BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    @NotNull
    public BuildContext call() throws Exception {
        String dockerPath = this.capabilityContext.getCapabilityValue("system.docker.executable");
        DockerCmd docker = new DockerCmd(this.processContextFactory.forCommonContext((CommonContext)this.buildContext), dockerPath, DefaultDockerProcessService.builder().workingDir(BuildContextHelper.getBuildWorkingDirectory((BuildContext)this.buildContext)).build(), this.dockerContainerService);
        Iterable<String> detachedContainers = CustomBuildDataHelper.getDetachedContainers(this.buildContext.getVariableContext());
        for (String detachedContainer : detachedContainers) {
            log.debug((Object)("Removing container: " + detachedContainer));
            docker.remove(detachedContainer);
        }
        return this.buildContext;
    }
}

